% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distancefilter.r
\name{distance_filter}
\alias{distance_filter}
\title{Filter locations by distance}
\usage{
distance_filter(sdata, distance1 = 100, distance2 = 100, method = 2)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
This filter is independently applied to a subset of data grouped by the unique "id". 
"DateTime" is date & time in class \code{\link[base]{POSIXct}}. "lat" and "lon" are the recorded latitude and longitude in decimal degrees. 
"qi" is the numerical quality index associated with each fix where the greater number represents better quality 
(e.g. number of GPS satellites used for estimation).}

\item{distance1}{A numeric value specifying threshold distance from a previous fix. Default is 100 km.}

\item{distance2}{A numeric value specifying threshold distance to a subsequent fix. Default is 100 km.}

\item{method}{An integer specifying how locations are filtered by distance. 
1 = a location is removed if the distance EITHER from a previous and to a subsequent location exceeds a given threshold speed. 
2 = a location is removed if the distance BOTH from a previous and to a subsequent location exceeds a given threshold speed. Default is FALSE.}
}
\value{
A data frame is returned without locations identified by this filter. 
The following columns are added: "pTime", "pDist". 
"pTime" is hours from a previous fix. "pDist" is straight distance in kilometres from a previous fix.
}
\description{
This function removes locations that are located beyond a given threshold distance.
}
\details{
This function removes locations if the distance both/either from a previous and to a subsequent location exceeds a given threshold distance.
}
\author{
Takahiro Shimada
}
