% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfilter.speed.r
\name{ddfilter.speed}
\alias{ddfilter.speed}
\title{Filter locations by speed}
\usage{
ddfilter.speed(sdata, vmax = 8.9, method = 2)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
This filter is independently applied to a subset of data grouped by the unique "id". 
"DateTime" is date & time in class \code{\link[base]{POSIXct}}. "lat" and "lon" are the recorded latitude and longitude in decimal degrees. 
"qi" is the numerical quality index associated with each fix where the greater number represents better quality 
(e.g. number of GPS satellites used for estimation).}

\item{vmax}{A numeric value specifying threshold speed both from a previous and to a subsequent fix. Default is 8.9 km/h. 
If this value is unknown, the function "est.vmax" can be used to estimate the value based on the supplied data.}

\item{method}{An integer specifying how locations are filtered by speed. 
1 = a location is removed if the speed EITHER from a previous and to a subsequent location exceeds a given threshold speed. 
2 = a location is removed if the speed BOTH from a previous and to a subsequent location exceeds a given threshold speed. Default is FALSE.}
}
\value{
A data frame is returned with the locations identified by this filter removed. 
The following columns are added: "pTime", "sTime", "pDist", "sDist", "pSpeed", "sSpeed". 
"pTime" and "sTime" are hours from a previous and to a subsequent fix respectively. 
"pDist" and "sDist" are straight distances in kilometres from a previous and to a subsequent fix respectively. 
"pSpeed" and "sSpeed" are linear speed from a previous and to a subsequent fix respectively.
}
\description{
A partial component of ddfilter, although works as a stand-alone function. 
This function removes locations by a given threshold speed as described in Shimada et al. (2012).
}
\details{
This function removes locations if the speed both/either from a previous and to a subsequent location exceeds a given threshold speed. 
If "vmax" is unknown, it can be estimated using the function "est.vmax".
}
\references{
Shimada T, Jones R, Limpus C, Hamann M (2012) 
Improving data retention and home range estimates by data-driven screening.
Marine Ecology Progress Series 457:171-180 doi:10.3354/meps09747
}
\seealso{
\code{\link{ddfilter}}, \code{\link{ddfilter.loop}}, \code{\link{est.vmax}}
}
\author{
Takahiro Shimada
}
