% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_ChordDiagramPlot.R
\name{do_ChordDiagramPlot}
\alias{do_ChordDiagramPlot}
\title{Generate a Chord diagram.}
\usage{
do_ChordDiagramPlot(
  sample = NULL,
  from = NULL,
  to = NULL,
  colors.from = NULL,
  colors.to = NULL,
  big.gap = 10,
  small.gap = 1,
  link.border.color = NA,
  link.border.width = 1,
  highlight_group = NULL,
  alpha.highlight = 25,
  link.sort = NULL,
  link.decreasing = TRUE,
  z_index = FALSE,
  self.link = 1,
  symmetric = FALSE,
  directional = 1,
  direction.type = c("diffHeight", "arrows"),
  link.arr.type = "big.arrow",
  scale = FALSE,
  alignment = "default",
  annotationTrack = c("grid", "axis"),
  padding_labels = 4,
  ...
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{from, to}{\strong{\code{\link[base]{character}}} | Categorical metadata variable to be used as origin and end points of the interactions.}

\item{colors.from, colors.to}{\strong{\code{\link[SCpubr]{named_vector}}} | Named vector of colors corresponding to the unique values of "from" and "to".}

\item{big.gap}{\strong{\code{\link[base]{numeric}}} | Space between the groups in "from" and "to".}

\item{small.gap}{\strong{\code{\link[base]{numeric}}} | Space within the groups.}

\item{link.border.color}{\strong{\code{\link[base]{character}}} | Color for the border of the links. NA = no color.}

\item{link.border.width}{\strong{\code{\link[base]{numeric}}} | Width of the border line of the links.}

\item{highlight_group}{\strong{\code{\link[base]{character}}} | A value from from that will be used to highlight only the links coming from it.}

\item{alpha.highlight}{\strong{\code{\link[base]{numeric}}} | A value between 00 (double digits) and 99 to depict the alpha of the highlighted links. No transparency needs "FF"}

\item{link.sort}{pass to \code{\link[circlize]{chordDiagramFromMatrix}} or \code{\link[circlize]{chordDiagramFromDataFrame}}
}

\item{link.decreasing}{pass to \code{\link[circlize]{chordDiagramFromMatrix}} or \code{\link[circlize]{chordDiagramFromDataFrame}}
}

\item{z_index}{\strong{\code{\link[base]{logical}}} | Whether to bring the bigger links to the top.}

\item{self.link}{\strong{\code{\link[base]{numeric}}} | Behavior of the links. One of:
\itemize{
\item \emph{\code{1}}: Prevents self linking.
\item \emph{\code{2}}: Allows self linking.
}}

\item{symmetric}{pass to \code{\link[circlize]{chordDiagramFromMatrix}}
}

\item{directional}{\strong{\code{\link[base]{numeric}}} | Set the direction of the links. One of:
\itemize{
\item \emph{\code{0}}: Non-directional data.
\item \emph{\code{1}}: Links go from "from" to "to".
\item \emph{\code{-1}}: Links go from "to" to "from".
\item \emph{\code{2}}: Links go in both directions.
}}

\item{direction.type}{\strong{\code{\link[base]{character}}} | How to display the directions. One of:
\itemize{
\item \emph{\code{diffHeight}}: Sets a line at the origin of the group showing to how many groups and in which proportion this group is linked to.
\item \emph{\code{arrows}}: Sets the connection as arrows.
\item \emph{\code{both}}: Sets up both behaviors. Use as: \code{c("diffHeight", "arrows")}.
}}

\item{link.arr.type}{\strong{\code{\link[base]{character}}} | Sets the appearance of the arrows. One of:
\itemize{
\item \emph{\code{triangle}}: Arrow with a triangle tip at the end displayed on top of the link.
\item \emph{\code{big.arrow}}: The link itself ends in a triangle shape.
}}

\item{scale}{\strong{\code{\link[base]{logical}}} | Whether to put all nodes the same width.}

\item{alignment}{\strong{\code{\link[base]{character}}} | How to align the diagram.  One of:
\itemize{
\item \emph{\code{default}}: Allows \pkg{circlize} to set up the plot as it sees fit.
\item \emph{\code{horizontal}}: Sets the break between "from" and "to" groups on the horizontal axis.
\item \emph{\code{vertical}}: Sets the break between "from" and "to" groups on the vertical axis.
}}

\item{annotationTrack}{pass to \code{\link[circlize]{chordDiagramFromMatrix}} or \code{\link[circlize]{chordDiagramFromDataFrame}}
}

\item{padding_labels}{\strong{\code{\link[base]{numeric}}} | Number of extra padding (white spaces) of the labels so that they do not overlap with the scales.}

\item{...}{For internal use only.}
}
\value{
A circlize plot.
}
\description{
Generate a Chord diagram.
}
\examples{
\donttest{
  # Define your Seurat object.
  sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

  # Basic chord diagram.
  sample$assignment <- ifelse(sample$seurat_clusters \%in\% c("0", "4", "7"), "A", "B")
  sample$assignment[sample$seurat_clusters \%in\% c("1", "2")] <- "C"
  sample$assignment[sample$seurat_clusters \%in\% c("10", "5")] <- "D"
  sample$assignment[sample$seurat_clusters \%in\% c("8", "9")] <- "E"

  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment")

  p

  # Increase gap between from and to groups.
  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   big.gap = 40)

  p

  # Increase gap width groups in from and to.
  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   small.gap = 5)

  p

  # Control the alignment of the diagram.
  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   alignment = "horizontal")

  p

  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   alignment = "vertical")

  p

  # Control direction of links.
  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   directional = 0,
                                   direction.type = "diffHeight")

  p

  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   directional = 1)

  p

  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   directional = -1)

  p

  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   directional = 2,
                                   direction.type = "diffHeight")

  p

  # Add more padding to the labels.
  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   padding_labels = 8)

  p

  # Scale the size of the nodes.
  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   scale = TRUE,
                                   padding_labels = 8)

  p

  # Prevent self linking.
  sample$seurat_clusters2 <- sample$seurat_clusters
  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "seurat_clusters2",
                                   self.link = 1,
                                   scale = TRUE)

  p

  # Allow self linking.
  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "seurat_clusters2",
                                   self.link = 2,
                                   scale = TRUE)

  p

  # Set triangle arrows.
  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   link.arr.type = "triangle")

  p

  # Set big arrows.
  p <- SCpubr::do_ChordDiagramPlot(sample = sample,
                                   from = "seurat_clusters",
                                   to = "assignment",
                                   link.arr.type = "big.arrow")

  p
}
}
