% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ginhoux}
\alias{ginhoux}
\title{scRNA-seq data of dendritic cell progenitors.}
\format{
A list containing two data frames, \code{expression} (248x2000) and \code{sample_info} (248x1).
}
\source{
\url{http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE60783}
}
\usage{
ginhoux
}
\description{
This dataset contains the expression values of the
top 2000 most variable genes for 248 dendritic cell progenitors.
Each cell is in one of three maturation stages: MDP, CDP or PreDC.
The levels of the factor in \code{sample.info} are ordered according to the maturation process.

The number of genes had to be reduced specifically for reducing the package size of SCORPIUS.
Use the following code to download the original data:
\preformatted{
download.file("https://github.com/rcannood/SCORPIUS/raw/master/data-raw/ginhoux_orig.rds", destfile = "local.rds")
ginhoux <- readRDS("local.rds")
# do something with ginhoux
}
}
\references{
Schlitzer A, Sivakamasundari V, Chen J, Sumatoh HR et al.
Identification of cDC1- and cDC2-committed DC progenitors reveals early lineage priming at
the common DC progenitor stage in the bone marrow. Nat Immunol 2015 Jul;16(7):718-28. PMID: 26054720
}
\seealso{
\link{SCORPIUS}
}
\keyword{datasets}
