% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCORNET.R
\name{scornet}
\alias{scornet}
\title{SCORNET Estimator}
\usage{
scornet(
  Delta,
  C,
  t0.all,
  C.UL = NULL,
  filter = NULL,
  filter.UL = NULL,
  Z0 = NULL,
  Z0.UL = NULL,
  Zehr = NULL,
  Zehr.UL = NULL,
  K = Knorm,
  b = NULL,
  h_hat = NULL,
  nCores = 1
)
}
\arguments{
\item{Delta}{Labeled set current status labels (I(T<C))}

\item{C}{Labeled set censoring times}

\item{t0.all}{Times at which to estimate survival}

\item{C.UL}{Unlabeled set censoring times}

\item{filter}{Labeled set binary filter indicators}

\item{filter.UL}{Unlabeled set filter indicators}

\item{Z0}{Labeled set baseline feature matrix}

\item{Z0.UL}{Unlabeled set baseline feature matrix}

\item{Zehr}{Labeled set EHR-derived feature matrix}

\item{Zehr.UL}{Unlabeled set EHR-derived feature matrix}

\item{K}{Kernel function (defaults to standard normal)}

\item{b}{bandwidth (default set heuristically)}

\item{h_hat}{N^1/4-consistent pdf estimator of C|Z0 (defaults to Kernel-Smoothed Cox/Breslow estimator)}

\item{nCores}{Number of cores to use for parallelization (defaults to 1)}
}
\value{
S_hat: Survival function estimates at times t0.all; StdErrs: Asymptotically consistent standard error estimates corresponding to S_hat
}
\description{
SCORNET Estimator
}
