% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id.R
\name{id}
\alias{id}
\alias{id.Id}
\alias{id.character}
\alias{id.data.frame}
\title{Convenience function for DBI::Id}
\usage{
id(db_table, ...)

\method{id}{Id}(db_table, conn = NULL, ...)

\method{id}{character}(db_table, conn = NULL, allow_table_only = TRUE, ...)

\method{id}{data.frame}(db_table, ...)
}
\arguments{
\item{db_table}{(\verb{id-like object(1)})\cr
A table specification (coercible by \code{id()}).}

\item{...}{Further arguments passed to methods.}

\item{conn}{(\code{DBIConnection(1)})\cr
Connection object.}

\item{allow_table_only}{(\code{logical(1)})\cr
If \code{TRUE}, allows for returning an \code{DBI::Id} with \code{table} = "myschema.table" if schema "myschema"
is not found in \code{conn}.
If \code{FALSE}, the function will raise an error if the implied schema cannot be found in \code{conn}.}
}
\value{
A \code{DBI::Id} object parsed from db_table (see details).
}
\description{
Convenience function for DBI::Id
}
\details{
The given \code{db_table} is parsed to a DBI::Id depending on the type of input:
\itemize{
\item \code{character}: db_table is parsed to a DBI::Id object using an assumption of "schema.table" syntax
with corresponding schema (if found in \code{conn}) and table values.
If no schema is implied, the default schema of \code{conn} will be used.
\item \code{DBI::Id}: if schema is not specified in \code{Id}, the schema is set to the default schema for \code{conn} (if given).
\item \code{tbl_sql}: the remote name is used to resolve the table identification.
\item \code{data.frame}: A Id is built from the data.frame (columns \code{catalog}, \code{schema}, and \code{table}).
Can be used in conjunction with \code{get_tables(conn, pattern)}.
}
}
\examples{
  id("schema.table")
}
\seealso{
\link[DBI:Id]{DBI::Id} which this function wraps.
}
