% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SC-MEB.R
\name{parafun}
\alias{parafun}
\title{parafun.}
\usage{
parafun(
  y,
  Adj,
  G,
  beta_grid = seq(0, 4, 0.2),
  PX = TRUE,
  maxIter_ICM = 10,
  maxIter = 50
)
}
\arguments{
\item{y}{is n-by-d PCs.}

\item{Adj}{is a sparse matrix of neighborhood.}

\item{G}{is an integer specifying the numbers of clusters.}

\item{beta_grid}{is a numeric vector specifying the smoothness parameter of Random Markov Field. The default is seq(0,4,0.2).}

\item{PX}{is a logical value specifying the parameter expansion in EM algorithm.}

\item{maxIter_ICM}{is the maximum iteration of ICM algorithm. The default is 10.}

\item{maxIter}{is the maximum iteration of EM algorithm. The default is 50.}
}
\value{
a list, We briefly explain the output of the SC.MEB. 
 
The item 'x' storing clustering results.

The item 'gam' is the posterior probability matrix.

The item 'ell' is the opposite log-likelihood. 

The item 'mu' is the mean of each component.

The item 'sigma' is the variance of each component.
}
\description{
The function parafun implements the model SC-MEB for fixed number of clusters and a sequence of beta with initial value from Gaussian mixture model
}
\details{
The function parafun implements the model SC-MEB for fixed number of clusters and a sequence of beta with initial value from Gaussian mixture model
}
\examples{
y = matrix(rnorm(50, 0, 1), 25,2)
pos = cbind(rep(1:5, each=5), rep(1:5, 5))
Adj_sp = getneighborhood_fast(pos, 1.2)
beta_grid = c(0.5,1)
G = 2
out = parafun(y, Adj_sp, G, beta_grid)
}
