% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SC-MEB.R
\name{ICMEM}
\alias{ICMEM}
\title{ICMEM.}
\usage{
ICMEM(
  y,
  x_int,
  Adj,
  mu_int,
  sigma_int,
  alpha,
  beta_grid,
  PX,
  maxIter_ICM,
  maxIter
)
}
\arguments{
\item{y}{is a matrix of PCs containing gene expression.}

\item{x_int}{is a vector of initial cluster label.}

\item{Adj}{is a matrix containing neighborhood information generated by find_neighbors2.}

\item{mu_int}{is a initial mean vector. we often generated it by Gaussian mixture model.}

\item{sigma_int}{is a initial co-variance matrix. we often generated it by Gaussian mixture model.}

\item{alpha}{is a intercept.}

\item{beta_grid}{is a sequence of smoothing parameter that can be specified by user.}

\item{PX}{is a logical value specifying the parameter expansion in EM algorithm.}

\item{maxIter_ICM}{is the maximum iteration of ICM algorithm.}

\item{maxIter}{is the maximum iteration of EM algorithm.}
}
\value{
a list.

The item 'x' is the clustering result. 

The item 'gam' is the posterior probability matrix.
 
The item 'ell' is the opposite log-likelihood. 

The item 'mu' is the mean of each component.

The item 'sigma' is the variance of each component.
}
\description{
The function ICMEM was used to conduct spatial clustering with hidden Markov random field for a sequence of beta and fixed number of clusters
}
\details{
The function ICMEM was used to conduct spatial clustering with hidden Markov random field for fixed beta and fixed number of clusters
}
\examples{
y = matrix(rnorm(50, 0, 1), 25,2)
pos = cbind(rep(1:5, each=5), rep(1:5, 5))
Adj = getneighborhood_fast(pos, 1.2)
beta_grid = c(0.5,1)
G = 2
fit_int = Mclust(y, G = G)
x_gmm <- fit_int$classification
mu_int <- unname(fit_int$parameter$mean)
sigma_int <- unname(fit_int$parameter$variance$sigma) 
alpha <- -log(fit_int$parameter$pro)*0
reslist <- ICMEM(y = y, x_int = x_gmm, Adj = Adj, mu_int = mu_int, sigma_int = sigma_int,
alpha = alpha, beta_grid = beta_grid, 
PX = TRUE, maxIter_ICM = 10, maxIter = 50) 
}
