### $Id: HR.R,v 1.1 2000/02/09 18:36:49 bates Exp $
### Heart rate repeated measures data.  Example 3.5 from
### "SAS System for Mixed Models"
"HR" <-
  structure(list(
  Patient = structure(ordered(c(23, 23, 23, 23, 
    23, 9, 9, 9, 9, 9, 21, 21, 21, 21, 21, 2, 2, 2, 2, 2, 12, 12, 
    12, 12, 12, 17, 17, 17, 17, 17, 7, 7, 7, 7, 7, 1, 1, 1, 1, 1, 
    8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 24, 24, 
    24, 24, 24, 6, 6, 6, 6, 6, 15, 15, 15, 15, 15, 3, 3, 3, 3, 3, 
    22, 22, 22, 22, 22, 5, 5, 5, 5, 5, 16, 16, 16, 16, 16, 19, 19, 
    19, 19, 19, 18, 18, 18, 18, 18, 14, 14, 14, 14, 14, 13, 13, 13, 
    13, 13, 20, 20, 20, 20, 20, 4, 4, 4, 4, 4), levels=1:24),
    class = c("ordered", "factor"),
    .Label = structure(c("208", "204", "216", "232", "218", 
      "214", "207", "209", "202", "210", "211", "205", "223", "222", 
      "215", "219", "206", "221", "220", "224", "203", "217", "201", 
      "212"),
      .Names = c("a1", "a2", "a3", "a4", "a5", "a6", "a7", 
        "a8", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "p1", "p2", 
        "p3", "p4", "p5", "p6", "p7", "p8"))),
Drug = structure(factor(c(3, 
  3, 3, 3, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 2, 2, 
  2, 2, 2, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1), levels=1:3),
  .Label = c("a", "b", "p")),
baseHR = c(92, 92, 92, 92, 92, 54, 54, 54, 54, 54, 
  84, 84, 84, 84, 84, 72, 72, 72, 72, 72, 80, 80, 80, 80, 80, 68, 
  68, 68, 68, 68, 100, 100, 100, 100, 100, 60, 60, 60, 60, 60, 
  88, 88, 88, 88, 88, 92, 92, 92, 92, 92, 88, 88, 88, 88, 88, 102, 
  102, 102, 102, 102, 84, 84, 84, 84, 84, 104, 104, 104, 104, 104, 
  92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 72, 72, 72, 72, 72, 72, 
  72, 72, 72, 72, 80, 80, 80, 80, 80, 72, 72, 72, 72, 72, 88, 88, 
  88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 78, 78, 78, 
  78, 78),
HR = c(76, 84, 88, 96, 84, 58, 60, 60, 60, 64, 86, 82, 
  84, 86, 82, 72, 68, 68, 78, 72, 84, 84, 96, 92, 72, 72, 68, 68, 
  64, 62, 104, 100, 92, 92, 68, 60, 58, 56, 50, 56, 104, 88, 88, 
  78, 84, 82, 82, 76, 82, 80, 80, 84, 80, 80, 78, 86, 86, 96, 86, 
  88, 92, 100, 88, 88, 80, 100, 96, 88, 92, 84, 80, 72, 64, 68, 
  64, 88, 84, 76, 88, 84, 84, 78, 80, 80, 76, 100, 92, 84, 88, 
  80, 80, 80, 78, 80, 78, 68, 76, 72, 72, 68, 88, 98, 98, 96, 88, 
  88, 96, 88, 88, 80, 78, 84, 64, 68, 64, 72, 72, 78, 80, 68),
Time = c(0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1, 0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1, 0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1, 0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1, 0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1, 0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1, 0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1, 0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1, 0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1, 0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1, 0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1, 0.016667, 
  0.083333, 0.25, 0.5, 1, 0.016667, 0.083333, 0.25, 0.5, 1)),
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
row.names = 1:120,
outer = ~Drug,
formula = HR ~ Time | Patient,
labels = list(y = "Heart Rate", x = "Time"),
units = list(y = "(beats/min)", x = "(min)"),
FUN = function (x) max(x, na.rm = TRUE),
order.groups = TRUE)
