% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onload.R
\name{get_rec_service}
\alias{get_rec_service}
\title{Get existing Azure recommender service}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} and \link[AzureRMR:az_subscription]{AzureRMR::az_subscription} classes.
}
\section{Usage}{
\preformatted{get_rec_service(name, data_container = "inputdata")
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the recommender service.
\item \code{data_container}: The name of the blob container within the storage account to use for storing datasets.
}
}

\section{Value}{

An object of class \code{az_rec_service} representing the deployed recommender service.
}

\examples{
\dontrun{

rg <- AzureRMR::az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# get a recommender service
rg$get_rec_service("myrec")

}
}
\seealso{
\link{create_rec_service}, \link{delete_rec_service}
}
