% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_S4_class_retro.R
\name{plot.retro}
\alias{plot.retro}
\alias{plot,retro,missing-method}
\alias{summary,retro-method}
\alias{summary.retro}
\title{Methods for retro object}
\usage{
\S4method{plot}{retro,missing}(x, color = NULL)

\S4method{summary}{retro}(object)
}
\arguments{
\item{x}{An object of class \linkS4class{retro}.}

\item{color}{An optional character vector of colors for plotting.}

\item{object}{An object of class \linkS4class{retro}.}
}
\value{
A series of plots showing retrospective patterns in fishing mortality, spawning biomass, recruitment, etc.
}
\description{
plot and summary functions for retro object.
}
\examples{
\donttest{
res <- SP(Data = swordfish)
ret <- retrospective(res, figure = FALSE)

summary(ret)
plot(ret)
}
}
\author{
Q. Huynh
}
