% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic.R
\name{diagnostic}
\alias{diagnostic}
\alias{diagnostic_AM}
\title{Diagnostic of assessments in MSE: did Assess models converge during MSE?}
\usage{
diagnostic(MSE, MP, gradient_threshold = 0.1, figure = TRUE)

diagnostic_AM(...)
}
\arguments{
\item{MSE}{An object of class MSE created by \code{\link[MSEtool]{runMSE}}.}

\item{MP}{Optional, a character vector of MPs that use assessment models.}

\item{gradient_threshold}{The maximum magnitude (absolute value) desired for the gradient of the likelihood.}

\item{figure}{Logical, whether a figure will be drawn.}

\item{...}{Arguments to pass to \code{diagnostic}.}
}
\value{
A matrix with diagnostic performance of assessment models in the MSE. If \code{figure = TRUE},
a set of figures: traffic light (red/green) plots indicating whether the model converged (defined if a positive-definite
Hessian matrix was obtained), the optimizer reached pre-specified iteration limits (as passed to \code{\link[stats]{nlminb}}),
and the maximum gradient of the likelihood in each assessment run. Also includes the number of optimization iterations
function evaluations reported by \code{\link[stats]{nlminb}} for each application of the assessment model.
}
\description{
Diagnostic check for convergence of Assess models during closed-loop simulation. Use when the MP was 
created with \link{make_MP} with argument \code{diagnostic = "min"} or \code{"full"}. 
This function summarizes and plots the diagnostic information.
}
\examples{
\donttest{
OM <- MSEtool::testOM; OM@proyears <- 20
myMSE <- runMSE(OM, MPs = "SCA_4010")
diagnostic(myMSE)
}
}
\seealso{
\link{retrospective_AM}
}
\author{
Q. Huynh
}
