% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SAENET.R
\name{SAENET.train}
\alias{SAENET.train}
\title{Build a stacked Autoencoder.}
\usage{
SAENET.train(X.train, n.nodes = c(4, 3, 2), unit.type = c("logistic",
  "tanh"), lambda, beta, rho, epsilon, optim.method = c("BFGS", "L-BFGS-B",
  "CG"), rel.tol = sqrt(.Machine$double.eps), max.iterations = 2000,
  rescale.flag = F, rescaling.offset = 0.001)
}
\arguments{
\item{X.train}{A matrix of training data.}

\item{n.nodes}{A vector of numbers containing the number of units
at each hidden layer.}

\item{unit.type}{hidden unit activation type as
per \code{autoencode()} params.}

\item{lambda}{Vector of scalars indicating weight decay per layer
as per \code{autoencode()}.}

\item{beta}{Vector of scalars indicating sparsity penalty per layer
as per \code{autoencode()}.}

\item{rho}{Vector of scalars indicating sparsity parameter per layer
as per \code{autoencode()}.}

\item{epsilon}{Vector of scalars indicating initialisation parameter
for weights per layer as per \code{autoencode()}.}

\item{optim.method}{Optimization method as per \code{optim()}.}

\item{rel.tol}{Relative convergence tolerance as per \code{optim()}}

\item{max.iterations}{Maximum iterations for \code{optim()}.}

\item{rescale.flag}{A logical flag indicating whether input data should
be rescaled.}

\item{rescaling.offset}{A small non-negative value used for rescaling.
Further description available in the documentation
of \code{autoencoder}.}
}
\value{
An object of class \code{SAENET} containing the following elements for each layer of the stacked autoencoder:
\item{ae.out}{ An object of class \code{autoencoder} containing the autoencoder created in that layer of the stacked autoencoder.}
\item{X.output}{ In layers subsequent to the first, a matrix containing the activations of the hidden neurons.}
}
\description{
Build a stacked Autoencoder.
}
\examples{
library(autoencoder)
data(iris)
#### Train a stacked sparse autoencoder with a (5,3) architecture and
#### a relatively minor sparsity penalty. Try experimenting with the
#### lambda and beta parameters if you haven't worked with sparse
#### autoencoders before - it's worth inspecting the final layer
#### to ensure that output activations haven't simply converged to the value of
#### rho that you gave (which is the desired activation level on average).
#### If the lambda/beta parameters are set high, this is likely to happen.


output <- SAENET.train(as.matrix(iris[,1:4]), n.nodes = c(5,3),
                       lambda = 1e-5, beta = 1e-5, rho = 0.01, epsilon = 0.01)
}

