% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repairInfeasRI2.R
\name{repairInfeasRI2}
\alias{repairInfeasRI2}
\title{Repair an infeasible solution with the method RI2}
\usage{
repairInfeasRI2(x, gReal, rbf.model, cobra, checkIt = FALSE)
}
\arguments{
\item{x}{an infeasible solution vector \eqn{\vec{x}} of dimension \code{d}}

\item{gReal}{a vector \eqn{(g_1(\vec{x}),\ldots,g_m(\vec{x}),
               h_1(\vec{x}),\ldots,h_r(\vec{x}))}  
holding the real constraint values at \eqn{\vec{x}}}

\item{rbf.model}{the constraint surrogate models}

\item{cobra}{parameter list, we need here 
\describe{
  \item{\code{lower}}{   lower bounds of search region}
  \item{\code{upper}}{   upper bounds of search region}
  \item{\code{ri}}{      a list with all parameters for \code{repairInfeasRI2}, 
                         see \code{\link{defaultRI}}  }
  \item{\code{trueFuncForSurrogate}}{ if TRUE (only for diagnostics), use the true constraint
                functions instead of the constraint surrogate models \code{rbf.model} }
  \item{\code{fn}}{   true functions, only needed in case of 
                      \code{trueFuncForSurrogate==TRUE} }
}}

\item{checkIt}{[FALSE] if TRUE, perform a check whether the returned solution is really 
feasible. Needs access to the true constraint functions.}
}
\value{
\code{z},  a vector of dimension \code{d} with a repaired (hopefully feasible) solution
}
\description{
If the solution \eqn{\vec{x}} is infeasible, i.e. if there is any \eqn{i} or any \eqn{j} such that
  \deqn{g_i(\vec{x})>0  or |h_j(\vec{x})| - currentEps >0}:
\enumerate{
   \item Estimate the gradient of the constraint surrogate function(s) (go a tiny step in each dimension 
     in the direction of constraint increase).
   \item 
     Take \code{cobra$ri$mmax} random realizations in the 'feasible parallelepiped'
     and select among them the best feasible solution, based on the surrogates,
   \item Check whether the new solution is for every dimension in the bounds 
     \code{[cobra$lower,cobra$upper]} of the search region. 
     If not, set the gradient to 0 in these dimensions and re-iterate from step 2. 
}
There is no guarantee but a good chance, that the returned solution \code{z} will be feasible.
}
\details{
For further details see  [Koch15a] Koch, P.; Bagheri, S.; Konen, W. et al. "A New Repair Method For Constrained 
Optimization". Proc. 17th Genetic and Evolutionary Computation Conference (GECCO), 2015.
}
\seealso{
\code{\link{repairChootinan}}, \code{\link{cobraPhaseII}}
}
\author{
Wolfgang Konen, Cologne University of Applied Sciences
}
