% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repairInfeasRI2.R
\name{repairInfeasibleW}
\alias{repairInfeasibleW}
\title{Wrapper for \code{\link{repairInfeasRI2}} (needed by RBFsearch.R).}
\usage{
repairInfeasibleW(resNM, fReal, rbf.model, cobra, checkIt = FALSE,
  conFunc = NULL)
}
\arguments{
\item{resNM}{a list as returned from optimizer (i.e. nmkb) with an infeasible
                    solution in \code{x = resNM$par}}

\item{fReal}{a (1 x nconstraint) matrix holding the real constraint values at \code{x}}

\item{rbf.model}{the constraint surrogate models}

\item{cobra}{parameter list, we need here
       lower        lower bounds of search region
       upper        upper bounds of search region
       ri           a list with all parameters for repairInfeasRI2}

\item{checkIt}{[FALSE] if TRUE, perform a check whether the returned solution is really feasible.
                    Needs access to the true constraint function \code{conFunc}}

\item{conFunc}{[NULL] function returning real constraint vector      (needed if checkIt==T)}
}
\value{
\code{resRI}  a list containing:
     \item{\code{par}}{ the repaired (feasible) solution }
     \item{\code{value}}{ copied from \code{resNM$value} }
     \item{\code{feval}}{ 0 (to indicate that this solution comes from \code{repairInfeasRI2}) }
     \item{\code{convergence}}{ 0 }
}
\description{
Wrapper for \code{\link{repairInfeasRI2}} (needed by RBFsearch.R).
}
\seealso{
\code{\link{repairInfeasRI2}}, \code{RBFsearch}
}
\keyword{internal}

