% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repairInfeasRI2.R
\name{repairInfeasRI2}
\alias{repairInfeasRI2}
\title{Repair an infeasible solution with the method RI2}
\usage{
repairInfeasRI2(x, fReal, rbf.model, cobra, checkIt = FALSE, conFunc = NULL)
}
\arguments{
\item{x}{an infeasible solution (vector of length \code{dimension})}

\item{fReal}{a vector of length nconstraint holding the real constraint values at \code{x}}

\item{rbf.model}{the constraint surrogate models}

\item{cobra}{parameter list, we need here
   \describe{
     \item{\code{lower}}{    lower bounds of search region}
     \item{\code{upper}}{    upper bounds of search region}
     \item{\code{ri}}{       a list with all parameters for \code{repairInfeasRI2}  }
     \item{\code{trueFuncForSurrogate}}{ if TRUE (only for diagnostics), use the true constraint
                    functions \code{conFunc} instead of the constraint surrogate models
                    \code{rbf.model} }
   }}

\item{checkIt}{[FALSE] if TRUE, perform a check whether the returned solution is really
                    feasible. Needs access to the true constraint function \code{conFunc}}

\item{conFunc}{[NULL] function returning real constraint vector (needed only
                    if \code{checkIt==T} or if \code{cobra$trueFuncForSurrogate==T})}
}
\value{
\code{z},  a vector with a repaired (hopefully feasible) solution
}
\description{
If the solution x is infeasible, i.e. if \code{any(fReal>0)==TRUE}:
 \enumerate{
   \item Estimate the gradient of the constraint surrogate function(s) (go a tiny step in each dimension
     in the direction of constraint increase).
   \item
     Take \code{cobra$ri$mmax} random realizations in the 'feasible parallelepiped'
     and select among them the best feasible solution, based on the surrogates,
   \item Check whether the new solution is for every dimension in the bounds
     \code{[cobra$lower,cobra$upper]} of the search region.
     If not, set the gradient to 0 in these dimensions and re-iterate from step 2.
 }
 There is no guarantee but a good chance, that the returned solution \code{z} will be feasible.
}
\details{
For further details see  [Koch15a] Koch, P.; Bagheri, S.; Konen, W. et al. "A New Repair Method For Constrained
 Optimization". Proc. 17th Genetic and Evolutionary Computation Conference (GECCO), 2015.
}
\author{
Wolfgang Konen, Cologne Univeristy of Applied Sciences
}
\seealso{
\code{\link{repairChootinan}}, \code{\link{cobraPhaseII}}
}

