% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yacas.R
\name{yacas}
\alias{yacas}
\alias{yacas.character}
\alias{yacas.expression}
\alias{yacas.function}
\alias{yacas.formula}
\alias{yacas.yacas}
\alias{as.expression.yacas}
\alias{as.character.yacas}
\alias{addSemi}
\alias{ynext}
\alias{ySequence}
\alias{ysub}
\alias{yparse}
\alias{yAssignFunction}
\title{yacas interface}
\usage{
yacas(x, ...)
\method{yacas}{character}(x, verbose = FALSE, method, 
    retclass = c("expression", "character", "unquote"), 
    addSemi = TRUE, ...)
}
\arguments{
\item{x}{A yacas character string or an R expression without terminating
semicolon to be processed by yacas.}

\item{\dots}{Additional arguments ultimately passed down to
\code{yacas.character}.}

\item{verbose}{A logical value indicating verbosity of output or
\code{"input"} to only show input to yacas but not output from yacas or
\code{"output"} to only show output from yacas but not input to yacas.}

\item{method}{method used to communicate with yacas.  If \code{"socket"} is
specified then the same yacas session is used on a sequence of calls.  If
\code{"system"} is specified then a new instance of yacas is used just for
the period of that call. \code{"system"} does not require that the system be
configured to support telnet/sockets and so may be useful in some instances.
If no value is specified the default is taken from
\code{getOption("yacas.method")} and if that is not specified "socket" is
used.  \code{"socket"} and \code{"system"} may be abbreviated.}

\item{addSemi}{If \code{TRUE} a semicolon is added to the character string
sent to yacas.  This can be set to \code{FALSE} if its known that the
character string already has a trailing semicolon.  It is ignored if
\code{retclass="expression"}.}

\item{retclass}{The class of the first component of the yacas structure.  It
defaults to \code{"expression"} but may be specified as \code{"character"}
or \code{"unquote"}.  \code{"unquote"} is the same as \code{"character"}
except that if the character string returned would have otherwise had quotes
in the first and and last positions then they are stripped.}
}
\value{
An R object of class \code{"yacas"} is returned.  If
\code{PrettyPrinter("OMForm")} is in effect, which it is by default, then
the first component is an R expression and the \code{OMForm} component
contains OpenMath XML code.  In other cases the first component is NULL and
the \code{YacasForm} or \code{PrettyForm} components have display
information.

Generally an expression. Refer to details.
}
\description{
Interface to the yacas computer algebra system.
}
\details{
The user supplies an R expression, an R function name corresponding to a
function with a single line body, a formula or a yacas input string.  In the
case of a formula it is regarded as an expression represented by the right
hand side of the formula while the left hand side, if any, is ignored.

Note the silent version \code{\link[=syacas]{syacas()}}.
}
\note{
Windows Installation.  On Windows one can install \code{Ryacas} by
issuing the commands:

\tabular{l}{ \code{install.packages("Ryacas", dep = TRUE)}\cr
\code{library(Ryacas)}\cr \code{yacasInstall()}\cr }

or by using the \code{Packages | Install package(s)} menu in place of the
first command.  The second command downloads \code{scripts.dat} and
\code{yacas.exe} from the internet and installs them into
\code{R_HOME/library/Ryacas/yacdir} where \code{R_HOME} is the location of
your \code{R} installation.

Normally the default locations of yacas, its initialization file and the
scripts file are sufficient but, if necessary, they can be overridden via
the environment variables: \code{YACAS_HOME}, \code{YACAS_INIT} and
\code{YACAS_SCRIPTS}. The \code{YACAS_INVOKE_STRING} environment variable
discussed in the next section overrides all three of these.

All OS Installation.  The \code{YACAS_INVOKE_STRING} environment variable
can be used to override the invocation string for yacas.  Normally it is not
used.  If it does need to be used then a typical use might be:

\tabular{l}{ \code{library(Ryacas)}\cr \code{# only need to do the file.copy
command once}\cr \code{file.copy(system.file("yacdir/R.ys", package =
"Ryacas"), "~/.yacsrc")}\cr \code{# this needs to be done once per
session}\cr \code{Sys.setenv(YACAS_INVOKE_STRING = "yacas -pc --server
9734")}\cr \code{demo(Ryacas) # test it out}\cr }

yacmode. There is also a utility yacmode which is called without arguments
and just turns R into a terminal into yacas until one quits out of it (and
back to R) by entering stop, end, quit, exit or e.

Startup. \code{yacas} starts up when \code{yacasStart()} is called or the
first time \code{yacas} is called.  yacas is shut down when
\code{yacasStop()} is called or when the package is detached using the
\code{detach()} R command.  On Windows, when yacas is shut down, the yacas
process is terminated on Windows XP Pro but not on other versions of
Windows. In those cases there will be a dangling process that the user must
terminate manually.

Translation.  The translation process occurs in several steps.  If the input
to the \code{yacas} function is an expression then it is translated to a
valid yacas character string (otherwise, it is sent to yacas unprocessed).
Yacas then processes the string and if \code{retclass="expression"} it is
translated back to an R expression (otherwise it is sent back unprocessed).
Examples of translations are:

\tabular{ll}{ R\tab yacas\cr sin(x)\tab Sin(x)\cr deriv(sin, x)\tab
Deriv(x)Sin(x)\cr log(x)\tab Ln(x)\cr }
}
\examples{

yacas(expression(Factor(x^2-1)))
exp1 <- expression(x^2 + 2 * x^2)
exp2 <- expression(2 * exp0)
exp3 <- expression(6 * pi * x)
exp4 <- expression((exp1 * (1 - sin(exp3))) / exp2)
print(yacas(exp4))

print(yacas("Version()")) # yacas version

# see demo("Ryacas-Function")

}
\references{
\url{http://www.yacas.org/}
}
\keyword{symbolmath}
