% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineAndUpdateVariables.R
\name{DefineTranslation}
\alias{DefineTranslation}
\title{Define translation}
\usage{
DefineTranslation(
  processData,
  UseProcessData = FALSE,
  DefinitionMethod = c("ResourceFile", "TranslationTable"),
  TranslationTable = data.table::data.table(),
  Conditional = FALSE,
  FileName = character()
)
}
\arguments{
\item{processData}{The current data produced by a previous instance of the function.}

\item{UseProcessData}{Logical: If TRUE use the existing function output in the process.}

\item{DefinitionMethod}{Character: A string naming the method to use, one of "TranslationTable" for defining the \code{TranslationTable}, and "ResourceFile" for reading the table from the file given by \code{FileName}.}

\item{TranslationTable}{A table of the columns \code{VariableName}, representing the variable to translate; \code{Value}, giving the values to translate; and \code{NewValue}, giving the values to translate to.}

\item{Conditional}{Logical: If TRUE the columns \code{ConditionalVariableName} and \code{ConditionalValue} are expected in the \code{TranslationTable}. These define a variable interacting with the \code{VariableName} and \code{Value}, so that \code{VariableName} is changed from \code{Value} to \code{NewValue} only when \code{ConditionalVariableName} has the value given by \code{ConditionalValue}. Note that \code{ConditionalVariableName} must exist in the same table as \code{VariableName}.}

\item{FileName}{The csv file holding a table with the three variables listed for \code{TranslationTable}.}
}
\value{
A \code{\link{Translation}} object.
}
\description{
This function defines the translation table used as input to \code{\link{TranslateStoxBiotic}} and similar functions to translate values of one or more columns to new values given by a table or read from a CSV file.
}
