% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saga.R
\name{saga_configure}
\alias{saga_configure}
\title{Generates a custom saga_cmd configuration file}
\usage{
saga_configure(senv, grid_caching = FALSE, grid_cache_threshold = 100,
  grid_cache_dir = NULL, cores = NULL, saga_vers)
}
\arguments{
\item{senv}{saga environment object object. SAGA-GIS environment and settings}

\item{grid_caching}{logical, whether to optionally use file caching, 
default = FALSE}

\item{grid_cache_threshold}{numeric, threshold (in Mb) before file caching
for loaded raster data is activated}

\item{grid_cache_dir}{character, path to directory for temporary files}

\item{cores}{numeric, maximum number of processing cores. Needs to be set to
1 if file caching is activated}

\item{saga_vers}{numeric_version, version of SAGA-GIS. The generation of a
saga_cmd configuration file is only valid for versions > 4.0.0}
}
\value{
character, path to custom saga_cmd initiation file
}
\description{
Creates and edits a saga_cmd coniguration file in order to change saga_cmd
settings related to file caching and number of available processor cores.
Intended to be used internally by \code{\link{saga_gis}}.
}
