% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{delta}
\alias{delta}
\title{Matrix difference operator}
\usage{
delta(J, i)
}
\arguments{
\item{J}{The number of matrix rows.}

\item{i}{The row number to which respect differences are computed.}
}
\value{
A matrix with \code{J-1} rows.
}
\description{
This function creates the difference operator matrix \code{delta} for
subtracting a matrix row from the other matrix rows.
}
\details{
Given a matrix \code{x} with \code{J} rows, then \code{delta(i,J) \%*\% x}
computes differences with respect to row \code{i}.
}
\examples{
J <- 2
x <- matrix(1, nrow = J, ncol = 2)
RprobitB:::delta(J, 1) \%*\% x

}
\keyword{internal}
\keyword{utils}
