% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mailmessages.get.R
\name{mailmessages.get}
\alias{mailmessages.get}
\title{Get one mail message}
\usage{
mailmessages.get(id, include_body = NULL, api_token = NULL,
  company_domain = "api")
}
\arguments{
\item{id}{ID of the mail message to fetch.}

\item{include_body}{Whether to include full message body or not. 0 = Don't include, 1 = Include This field has the following domains: (0; 1)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Get one mail message from pipedrive.
}
\examples{
\donttest{
mailmessages.get(id='e.g.',api_token='token',company_domain='exp')
}
}
