% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persons.get.activities.R
\name{persons.get.activities}
\alias{persons.get.activities}
\title{List activities associated with a person}
\usage{
persons.get.activities(id, start = NULL, limit = NULL, done = NULL,
  exclude = NULL, api_token = NULL, company_domain = "api")
}
\arguments{
\item{id}{ID of the person}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{done}{Whether to fetch done (1) or undone (0) activities. If omitted from request, both undone and done activities are fetched. This field has the following domains: (0; 1)}

\item{exclude}{A comma-separated string of activity IDs to exclude from result}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to List activities associated with a person from pipedrive.
}
\examples{
\donttest{
persons.get.activities(id='e.g.',api_token='token',company_domain='exp')
}
}
