% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.coords.R
\name{merge.coords}
\alias{merge.coords}
\alias{merge.atoms}
\alias{merge.pdb}
\title{Merging Molecular Systems}
\usage{
\method{merge}{coords}(x, y, ...)

\method{merge}{atoms}(x, y, reindex = TRUE, ...)

\method{merge}{pdb}(x, y, reindex = TRUE, ...)
}
\arguments{
\item{x, y}{objects of class 'coords' to be merged.}

\item{\dots}{further arguments passed to or from other methods.}

\item{reindex}{a single element logical vector indicating if residue and
element IDs have to be reindexed after merging.}
}
\value{
Return an object of the same class as \code{x} and \code{y} merging 
  \code{x} and \code{y}. If \code{x} and \code{y} have different \code{basis}
  attributes an error is returned.
}
\description{
Merge two objects contaning atomic coordinates
}
\details{
To merge \code{x} and \code{y} they must have the same \code{basis} 
attributes (see \code{\link{basis}}). \cr\cr For objects of class 
\sQuote{coords} and \sQuote{atoms} the atomic coordinates are directly merged
by row. \cr\cr For objects of class \sQuote{pdb}, the \code{atoms} and 
\code{conect} components of the two \code{pdb} objects are merged by row and 
the \code{cryst1} components of \code{x} is used to build the returned 
object. \cr\cr For objects of class \sQuote{atoms} and \sQuote{pdb} the 
residue and element IDs of \code{y} are shifted to avoid any confusion with 
those of \code{x}. If \code{reindex == TRUE} the \code{\link{reindex}} function
is called to reinitialize the indexing of the returned object.
}
\examples{
c1 <- coords( 1:3 ,  4:6 ,  7:9 , basis = "xyz")
c2 <- coords(10:12, 13:15, 16:18, basis = "xyz")
merge(c1,c2)

\donttest{
## Merging objects with different basis sets returns an error.
c2 <- coords(9:11, 12:14, 15:17, basis = "abc")
try(merge(c1,c2))
}

## Prepare a Pentacene/C70 dimer
C70 <- read.pdb(system.file("examples/C70.pdb", package="Rpdb"))
Pen <- read.pdb(system.file("examples/Pentacene.pdb", package="Rpdb"))
x <- merge(Tz(C70, 3.5, thickness=0.5), Pen)
  
}
\seealso{
\code{\link{coords}}, \code{\link{atoms}}, \code{\link{pdb}},
  \code{\link{basis}}, \code{merge}, \code{merge.data.frame}
}
\keyword{manip}
