% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/InstanceSelection.R
\name{IS.FRIS.FRST}
\alias{IS.FRIS.FRST}
\title{The fuzzy rough instance selection algorithm}
\usage{
IS.FRIS.FRST(decision.table, control = list())
}
\arguments{
\item{decision.table}{a \code{"DecisionTable"} class representing the decision table. See \code{\link{SF.asDecisionTable}}.}

\item{control}{a list of other parameters which are
\itemize{
\item \code{threshold.tau}: a value determining whether an object can be removed or not.
      The object can be removed if it is less than the threshold. The default value is 0.95.
\item \code{alpha}: a parameter determining the granularity of the fuzzy similarity measure, which has positive values (>= 0). The default value is 1.
\item \code{type.aggregation}: a list representing the type of aggregation and its value.
      The default value is \code{type.aggregation = c("t.tnorm", "lukasiewicz")}. See \code{\link{BC.IND.relation.FRST}}.
\item \code{t.implicator}: a string representing the value of implicator function. The default value is \code{"lukasiewicz"}. See \code{\link{BC.LU.approximation.FRST}}.
}}
}
\value{
A class \code{"InstanceSelection"} that contains the following components:
\itemize{
\item \code{indx.objects}: it contains all indexes of objects that are selected.
\item \code{type.method}: a string representing the type of method. In this case, it is \code{"IS.FRIS"}.
\item \code{type.task}: a string showing the type of task which is \code{"instance selection"}.
\item \code{type.model}: a string representing the type of model which is \code{"FRST"}.
}
}
\description{
This is a function that implements the fuzzy-rough instance selection (FRIS) proposed by
(Jensen and Cornelis, 2010) which is used to perform instance selection.
}
\details{
FRIS is used to remove training instances that cause conflicts with other instances as
determined by the fuzzy positive region.

This algorithm evaluates the degree of membership of each instance to the fuzzy positive region.
If there is a instance less than the threshold, then the instance can be removed.
Additionally, it uses a fuzzy indiscernibility relation \eqn{R_a} to express the approximate equality between
objects \eqn{x} and \eqn{y} on attribute \eqn{a} in the training set:

\eqn{R_{a}^{\alpha}(x,y)=max(0, 1 - \alpha \frac{|a(x) - a(y)|}{l(a)})}

where parameter \eqn{\alpha} (\eqn{\alpha \ge 0}) determines the granularity of \eqn{R_{a}^{\alpha}}.
Then, the fuzzy \eqn{B}-indiscernibility relation, fuzzy lower approximation, positive region and degree of dependency are calculated based on
the concept in \code{\link{B.Introduction-FuzzyRoughSets}}.

It should be noted that this function does not give the new decision table directly.
The other additional function called \code{\link{SF.applyDecTable}} is used to produce the new decision table based on
the output of this function.
}
\examples{
#############################################
## Example: Evaluate instances/objects and
##          generate new decision table
#############################################
dt.ex1 <- data.frame(c(0.1, 0.5, 0.2, 0.3, 0.2, 0.2, 0.8),
                  c(0.1, 0.1, 0.4, 0.2, 0.4, 0.4, 0.5), c(0, 0, 0, 0, 1, 1, 1))
colnames(dt.ex1) <- c("a1", "a2", "d")
decision.table <- SF.asDecisionTable(dataset = dt.ex1, decision.attr = 3, indx.nominal = c(3))

## evaluate index of objects
res.1 <- IS.FRIS.FRST(decision.table = decision.table, control =
                        list(threshold.tau = 0.5, alpha = 0.8,
                        type.aggregation = c("t.tnorm", "lukasiewicz"),
                        t.implicator = "lukasiewicz"))

## generate new decision table
new.decTable <- SF.applyDecTable(decision.table, res.1)
}
\author{
Lala Septem Riza
}
\references{
R. Jensen and C. Cornelis, "Fuzzy-rough Instance Selection",
Proceedings of the 19th International Conference on Fuzzy Systems (FUZZ-IEEE 2010),
p. 1776 - 1782 (2010).
}
\seealso{
\code{\link{IS.FRPS.FRST}}.
}

