% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{adstock_geometric}
\alias{adstock_geometric}
\alias{adstock_weibull}
\alias{plot_adstock}
\title{Adstocking Transformation (Geometric and Weibull)}
\usage{
adstock_geometric(x, theta)

adstock_weibull(x, shape, scale, windlen = length(x), type = "CDF")

plot_adstock(plot = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{theta}{Numeric. Theta is the only parameter on Geometric Adstocking and means
fixed decay rate. Assuming TV spend on day 1 is 100€ and theta = 0.7, then day 2 has
100 x 0.7 = 70€ worth of effect carried-over from day 1, day 3 has 70 x 0.7 = 49€
from day 2 etc. Rule-of-thumb for common media genre: TV c(0.3, 0.8), OOH/Print/
Radio c(0.1, 0.4), digital c(0, 0.3).}

\item{shape, scale}{Numeric. Check "Details" section for more details.}

\item{windlen}{Integer. Length of modelling window. By default, same length as \code{x}.}

\item{type}{Character. Accepts "CDF" or "PDF". CDF, or cumulative density
function of the Weibull function allows changing decay rate over time in both
C and S shape, while the peak value will always stay at the first period,
meaning no lagged effect. PDF, or the probability density function, enables
peak value occurring after the first period when shape >=1, allowing lagged
effect.}

\item{plot}{Boolean. Do you wish to return the plot?}
}
\value{
Numeric values. Transformed values.
}
\description{
\code{adstock_geometric()} for Geometric Adstocking is the classic one-parametric
adstock function.

\code{adstock_weibull()} for Weibull Adstocking is a two-parametric adstock
function that allows changing decay rate over time, as opposed to the fixed
decay rate over time as in Geometric adstock. It has two options, the cumulative
density function "CDF" or the probability density function "PDF".
}
\details{
\describe{
  \item{Weibull's CDF (Cumulative Distribution Function)}{has
two parameters, shape & scale, and has flexible decay rate, compared to Geometric
adstock with fixed decay rate. The shape parameter controls the shape of the decay
curve. Recommended bound is c(0.0001, 2). The larger the shape, the more S-shape. The
smaller, the more L-shape. Scale controls the inflexion point of the decay curve. We
recommend very conservative bounce of c(0, 0.1), because scale increases the adstock
half-life greatly.}
  \item{Weibull's PDF (Probability Density Function)}{also shape & scale as parameter
and also has flexible decay rate as Weibull CDF. The difference is that Weibull PDF
offers lagged effect. When shape > 2, the curve peaks after x = 0 and has NULL slope at
x = 0, enabling lagged effect and sharper increase and decrease of adstock, while the
scale parameter indicates the limit of the relative position of the peak at x axis; when
1 < shape < 2, the curve peaks after x = 0 and has infinite positive slope at x = 0,
enabling lagged effect and slower increase and decrease of adstock, while scale has the
same effect as above; when shape = 1, the curve peaks at x = 0 and reduces to exponential
decay, while scale controls the inflexion point; when 0 < shape < 1, the curve peaks at
x = 0 and has increasing decay, while scale controls the inflexion point. When all
possible shapes are relevant, we recommend c(0.0001, 10) as bounds for shape; when only
strong lagged effect is of interest, we recommend c(2.0001, 10) as bound for shape. In
all cases, we recommend conservative bound of c(0, 0.1) for scale. Due to the great
flexibility of Weibull PDF, meaning more freedom in hyperparameter spaces for Nevergrad
to explore, it also requires larger iterations to converge.}
}

Run \code{plot_adstock()} to see the difference visually.
}
\examples{
adstock_geometric(rep(100, 5), theta = 0.5)
adstock_weibull(rep(100, 5), shape = 0.5, scale = 0.5, type = "CDF")
adstock_weibull(rep(100, 5), shape = 0.5, scale = 0.5, type = "PDF")

plot_adstock()
}
\seealso{
Other Transformations: 
\code{\link{mic_men}()},
\code{\link{saturation_hill}()}
}
\concept{Transformations}
