% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainExtRidge.R
\name{tuneandtrainExtRidge}
\alias{tuneandtrainExtRidge}
\title{Tune and Train External Ridge}
\usage{
tuneandtrainExtRidge(data, dataext, maxit = 120000, nlambda = 100)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable (factor), 
and the remaining columns should be the predictor variables.}

\item{dataext}{A data frame containing the external validation data. The first column should be the response 
variable (factor), and the remaining columns should be the predictor variables.}

\item{maxit}{An integer specifying the maximum number of iterations. Default is 120000.}

\item{nlambda}{An integer specifying the number of lambda values to use in the Ridge model. Default is 100.}
}
\value{
A list containing the best lambda value (`best_lambda`), the final trained model (`best_model`), 
  the AUC of the final model on the training data (`final_auc`).
}
\description{
This function tunes and trains a Ridge classifier using the \code{glmnet} package. The function 
evaluates a sequence of lambda (regularization) values on an external validation dataset and selects 
the best model based on the Area Under the Curve (AUC).
}
\details{
This function trains a logistic Ridge regression model on the training dataset and validates it on the external 
validation dataset. The lambda value that gives the highest AUC on the external validation dataset is selected 
as the best model.
}
\examples{
# Load sample data
data(sample_data_train)
data(sample_data_extern)

# Example usage
result <- tuneandtrainExtRidge(sample_data_train, sample_data_extern, maxit = 120000, nlambda = 100)
result$best_lambda
result$best_model
result$final_auc
}
