% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_portfolios.R
\name{get_portfolios}
\alias{get_portfolios}
\title{Get portfolio summaries related to your RobinHood Account}
\usage{
get_portfolios(RH, interval = NULL, span = NULL)
}
\arguments{
\item{RH}{object of class RobinHood}

\item{interval}{(string) Interval of time to aggregate to (examples: hour, day, week, month)}

\item{span}{(string) Period of time you are interested in (examples: day, week, month, year)}
}
\description{
Returns a dataframe of portfolio summaries for a specific period of time. Default is current day.
}
\examples{
\dontrun{
# Login in to your RobinHood account
RH <- RobinHood("username", "password")

get_portfolios(RH)
get_portfolios(RH, interval = "day", span = "3month")
}
}
