% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generate_Data.R
\name{Generate_Data}
\alias{Generate_Data}
\title{Simulate data from a Kalman model}
\usage{
Generate_Data(
  n,
  A,
  C,
  Sigma_Add,
  Sigma_Inn,
  mu_0 = NULL,
  anomaly_loc = integer(0),
  anomaly_type = character(0),
  anomaly_comp = integer(0),
  anomaly_strength = NULL
)
}
\arguments{
\item{n}{A positive integer giving the number of observations desired}

\item{A}{A matrix giving the updates for the hidden states.}

\item{C}{A matrix mapping the hidden states to the observed states.}

\item{Sigma_Add}{A positive definite diagonal matrix giving the additive noise covariance.}

\item{Sigma_Inn}{A positive definite diagonal matrix giving the innovative noise covariance.}

\item{mu_0}{A matrix indicating the mean of the prior for the hidden states. It defaults to a zero-vector.}

\item{anomaly_loc}{A vector of integers giving the locations of anomalies.}

\item{anomaly_type}{A vector of strings, either "Add" or "Inn" indicating whether the anomaly is additive or innovative.}

\item{anomaly_comp}{A vector of integers giving the component affected by the anomalies.}

\item{anomaly_strength}{A vector of numerics giving the strength of the anomalies (in sigmas).}
}
\value{
A list of matrices, each corresponding to an observation.
}
\description{
This function simulates data obeying a Kalman model whilst allowing the user to add innovative and additive anomalies.
}
\examples{

library(RobKF)
library(ggplot2)

set.seed(2018)

A = diag(2)*0.99
A[1,2] = -0.05
C = matrix(c(10,0.1),nrow=1)
mu = matrix(c(0,0),nrow=2)
Sigma_Inn = diag(c(1,0.01)*0.00001,nrow=2)
Sigma_Add = diag(c(1)*0.1,nrow=1)

Y_list = Generate_Data(100,A,C,Sigma_Add,Sigma_Inn, mu_0 = mu,  anomaly_loc = c(10,30,50), 
                      anomaly_type = c("Inn","Add","Inn"), 
                      anomaly_comp = c(1,1,2),  anomaly_strength = c(400,-10,3000))
                      
qplot(1:100,unlist(Y_list),xlab="time",ylab="observation")+theme_minimal()


}
