% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors_calibration.R
\name{calibrate_quartiles}
\alias{calibrate_quartiles}
\title{Calibrate prior distributions based on quartiles}
\usage{
calibrate_quartiles(
  median_t,
  iq_range_t,
  prior_sd = 0.5,
  distributions = c("exp-aft", "weibull-aft", "lnorm-aft", "llogis-aft", "gamma-aft"),
  verbose = FALSE,
  search_bounds1 = c(-100, 100),
  search_bounds2 = c(0 + 0.01, 100)
)
}
\arguments{
\item{median_t}{median survival}

\item{iq_range_t}{interquartile range of the survival}

\item{prior_sd}{pre-specified standard deviation of the
prior distributions (either a single value that is used
for both the intercept and auxiliary parameter or a vector
where the first value corresponds to the sd for the prior
distribution on the intercept and the second value to the
sd for the prior distribution on the auxiliary parameter)}

\item{distributions}{vector of parametric families for which
prior distributions ought to be calibrated}

\item{verbose}{whether debug information be printed}

\item{search_bounds1}{search boundaries for the intercept
parameter}

\item{search_bounds2}{search boundaries for the auxiliary
parameter}
}
\value{
returns a list of prior distribution for the intercepts
and auxiliary parameters.
}
\description{
Calibrates prior distributions for parametric
survival analysis based on median survival and interquartile
range. Returns a list of prior distribution for the intercepts
and auxiliary parameters.
}
\examples{
priors <- calibrate_quartiles(median_t = 5, iq_range_t = 10, prior_sd = 0.5)


}
