% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Assign_Vmetadata.R
\docType{methods}
\name{Assign_Vmetadata}
\alias{Assign_Vmetadata}
\alias{Assign_Vmetadata,rnetBasic-method}
\alias{Assign_Vmetadata,rnetStrata-method}
\alias{Assign_Vmetadata,rnetMultiStrata-method}
\title{Assign_Vmetadata - Methods for assigning network vertex metadata}
\usage{
Assign_Vmetadata(network, V_metadata, match.attr = NULL,
  vertex.match.attr = "name", reassign = T)

\S4method{Assign_Vmetadata}{rnetBasic}(network, V_metadata, match.attr = NULL,
  vertex.match.attr = "name", reassign = T)

\S4method{Assign_Vmetadata}{rnetStrata}(network, V_metadata,
  match.attr = NULL, vertex.match.attr = "name", reassign = T)

\S4method{Assign_Vmetadata}{rnetMultiStrata}(network, V_metadata,
  match.attr = NULL, vertex.match.attr = "name", reassign = T)
}
\arguments{
\item{network}{The network to which the vertex metadata will be applied.}

\item{V_metadata}{A dataframe containing the vertex metadata to be assigned. A vertex attribute will be assigned for every column in the frame, except the column used to match V_metadata to existing vertex attribues.}

\item{match.attr}{The name of the column in V_metadata used to match metadata to vertices. Defaults to the first column of V_metadata.}

\item{vertex.match.attr}{the name of the vertex attribute used to match metadata. Defaults to 'name' (V(network)$name), which is typically assigned when the network is created with igraph functions.}

\item{reassign}{A logical argument controling if the function should overwrite the called network argument. Defaults to 'True' for brevity.}
}
\value{
An object of the same type as x, with the new vertex attributes assigned by matching 'match.attr' to 'vertex.match.attr'.
}
\description{
This method assigns metadata to vertices in an igraph object based on an existing vertex attibute, typically vertex name, but can be done with other attributes including those assigned with previous calls with this method.
}
\details{
This method also works with all rnet objects (currently class 'rnetBasic', 'rnetStrata', and 'rnet.multi.strata'), and also adds the names of the metadata attributes to the 'V_metadata' slot.
}
\examples{
# V_ATTRS' is a data.frame included in the package containing vertex metadata
#     regarding antimicrobial class and a color scheme for the vertices. These 
#     attributes are useful for plotting and determining modularity.

ABX_LIST <- c('AMP', 'AMC', 'AXO', 'TIO', 'NAL', 'CIP', 'STR', 'GEN', 'COT', 'FIS')

EC08_rnet <- Rnet(NARMS_EC_DATA, 
  L1 = 0.25, 
  V_set = ABX_LIST, 
  Stratify = NARMS_EC_DATA$Year == 2008
  )

#Attributes prior to additions
vertex_attr_names(EC08_rnet@R)
vertex_attr(EC08_rnet@R)

Assign_Vmetadata(EC08_rnet, 
                 V_metadata = V_ATTRS,
                 match.attr = 'Code',
                 vertex.match.attr = 'name'
                 )

#NOTE: EC08_rnet does not need to be reassigned for brevity. Returns data.frame of assigned data.
#      Reassignment can be performed, if desired. data.frame not returned in such a case.

EC08_withAttrs <- Assign_Vmetadata(EC08_rnet, 
                 V_metadata = V_ATTRS,
                 match.attr = 'Code',
                 vertex.match.attr = 'name'
                 )

#Atrributes after edges assigned.
vertex_attr(EC08_rnet@R)
}
