/*
 * Decompiled with CFR 0.152.
 */
package org.math.r.activemq.logger;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQTextMessage;

public class Producer {
    private String url = "failover://tcp://localhost:61616";
    private Session session;
    private MessageProducer producer;
    private Connection connection;

    public Producer(String url, String field, String name) {
        if (url != null) {
            this.url = url;
        }
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.url);
        try {
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            Object destination = "T".equals(field) ? this.session.createTopic(name) : this.session.createQueue(name);
            this.producer = this.session.createProducer((Destination)destination);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public boolean send(byte[] obj, String propertyName, String propertyValue) {
        Boolean success = false;
        try {
            ActiveMQBytesMessage message = new ActiveMQBytesMessage();
            message.writeBytes(obj);
            if (propertyName != null) {
                message.setStringProperty(propertyName, propertyValue);
            }
            this.producer.send((Message)message);
            success = true;
        }
        catch (JMSException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    public boolean send(String obj, String propertyName, String propertyValue) {
        Boolean success = false;
        try {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setText(obj);
            if (propertyName != null) {
                message.setStringProperty(propertyName, propertyValue);
            }
            this.producer.send((Message)message);
            success = true;
        }
        catch (JMSException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    public boolean destroy() {
        Boolean success = false;
        try {
            this.connection.close();
            success = true;
        }
        catch (JMSException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }
}

