% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_test_cont_adj.R
\name{gof_test_cont_adj}
\alias{gof_test_cont_adj}
\title{This function performs a number of gof tests for continuous data and finds the adjusted p value}
\usage{
gof_test_cont_adj(
  x,
  pnull,
  rnull,
  w = function(x) -99,
  phat = function(x) 0,
  TS,
  TSextra = NA,
  nbins = c(50, 10),
  rate = 0,
  Range = c(-Inf, Inf),
  B = c(5000, 1000),
  minexpcount = 5,
  ChiUsePhat = TRUE,
  doMethods = c("W", "ZC", "AD", "ES-s-P")
)
}
\arguments{
\item{x}{data set}

\item{pnull}{cdf under the null hypothesis}

\item{rnull}{routine to generate data under the null hypothesis}

\item{w}{(Optional) function to calculate weights, returns -99 if no weights}

\item{phat}{=function(x) -99, function to estimate parameters from the data, or -99 if no parameters aare estimated}

\item{TS}{user supplied function to find test statistics, if any}

\item{TSextra}{=NA, list passed to TS, if desired}

\item{nbins}{=c(50, 10) number of bins for chi-square tests}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{Range}{=c(-Inf, Inf) limits of possible observations, if any, for chi-square tests}

\item{B}{=c(5000,1000)  number of simulation runs for p values and for p value distribution}

\item{minexpcount}{=5 minimal expected bin count required}

\item{ChiUsePhat}{=TRUE, if TRUE param is estimated parameter, otherwise minimum chi square method is used.}

\item{doMethods}{Methods to include in tests}
}
\value{
None
}
\description{
This function performs a number of gof tests for continuous data and finds the adjusted p value
}
