% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_test_disc.R
\name{gof_test_disc}
\alias{gof_test_disc}
\title{This function performs a number of gof tests for discrete data.}
\usage{
gof_test_disc(
  x,
  pnull,
  rnull,
  vals,
  phat,
  nbins = c(100, 10),
  rate = 0,
  B = 5000,
  doMethod = "Default"
)
}
\arguments{
\item{x}{data set (the counts)}

\item{pnull}{cumulative distribution function under the null hypothesis}

\item{rnull}{routine to generate data under the null hypothesis}

\item{vals}{a vector of values of discrete random variables}

\item{phat}{a function to estimate parameters from the data}

\item{nbins}{=c(100, 10) number of bins for chi-square tests}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{B}{=5000  number of simulation runs}

\item{doMethod}{Methods to include in tests}
}
\value{
A numeric matrix of test statistics and p values
}
\description{
This function performs a number of gof tests for discrete data.
}
\examples{
# Tests to see whether data comes from a binomial (10, 0.5) distribution.
vals=0:10
pnull = function() pbinom(0:10, 10, 0.5)
rnull = function() table(c(0:10, rbinom(1000, 10, 0.5)))-1
x = rnull() 
gof_test_disc(x, pnull, rnull, vals)
# Tests to see whether data comes from a binomial distribution with the success probability 
# estimated from the data.
pnull = function(p=0.5) pbinom(0:10, 10, ifelse(p>0&&p<1,p,0.001))
rnull = function(p=0.5) table(c(0:10, rbinom(1000, 10, ifelse(p>0&&p<1,p,0.001))))-1
phat = function(x) mean(0:10*x)/1000 
gof_test_disc(x, pnull, rnull, vals, phat)  
}
