% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_datasets}
\alias{search_datasets}
\title{Search for Datasets}
\usage{
search_datasets(client, page_size = NULL, page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for Datasets
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{
## Use the client to search for datasets
library(magrittr)
datasets <- ref_client \%>\% search_datasets() \%>\% content()
datasets

## Or specify the API location within search_datasets
search_datasets("http://1kgenomes.ga4gh.org")


}

}

