% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestry.R
\name{correctedPredict}
\alias{correctedPredict}
\title{correctedPredict-forestry}
\usage{
correctedPredict(
  object,
  newdata = NULL,
  feats = NULL,
  nrounds = 0,
  linear = TRUE,
  double = FALSE,
  simple = TRUE,
  verbose = FALSE,
  use_residuals = FALSE,
  adaptive = FALSE,
  monotone = FALSE,
  num_quants = 5,
  params.forestry = list(),
  keep_fits = FALSE
)
}
\arguments{
\item{object}{A `forestry` object.}

\item{newdata}{Dataframe on which to predict. If this is left NULL, we
predict on the in sample data.}

\item{feats}{A vector of feature indices which should be included in the bias
correction. By default only the outcome and predicted outcomes are used.}

\item{nrounds}{The number of nonlinear bias correction steps which should be
taken. By default this is zero, so just a single linear correction is used.}

\item{linear}{A flag indicating whether or not we want to do a final linear
bias correction after doing the nonlinear corrections. Default is TRUE.}

\item{double}{A flag indicating if one should use aggregation = "doubleOOB" for
the initial predictions rather than aggregation = "oob." Default is FALSE.}

\item{simple}{flag indicating whether we should do a simple linear adjustment
or do different adjustments by quantiles. Default is TRUE.}

\item{verbose}{flag which displays the bias of each qunatile.}

\item{use_residuals}{flag indicating if we should use the residuals to fit the
bias correction steps. Defualt is FALSE which means that we will use Y
rather than Y-Y.hat as the regression outcome in the bias correction steps.}

\item{adaptive}{flag to indicate whether we use adaptiveForestry or not in the
regression step. Default is FALSE.}

\item{monotone}{flag to indicate whether or not we should use monotonicity
in the regression of Y on Y hat (when doing forest correction steps).
If TRUE, will constrain the corrected prediction for Y to be monotone in the
original prediction of Y. Default is FALSE.}

\item{num_quants}{Number of quantiles to use when doing quantile specific bias
correction. Will only be used if simple = FALSE. Default is 5.}

\item{params.forestry}{A list of parameters to pass to the subsequent forestry
calls. Note that these forests will be trained on features of dimension
length(feats) + 1 as the correction forests are trained on Y ~ cbind(newdata[,feats], Y.hat).
so monotonic constraints etc given to this list should be of size length(feats) + 1.
Defaults to the standard forestry parameters for any parameters that are
not included in the list.}

\item{keep_fits}{A flag that indicates if we should save the intermediate
forests used for the bias correction. If this is TRUE, we return a list of
the forestry objects for each iteration in the bias correction.}
}
\value{
A vector of the bias corrected predictions
}
\description{
Perform predictions given the forest using a bias correction based on
  the out of bag predictions on the training set. By default we use a final linear
  correction based on the leave-one-out hat matrix after doing `nrounds` nonlinear
  corrections.
}
\examples{
 library(Rforestry)
 set.seed(121235312)
 n <- 50
 p <- 10
 x <- matrix(rnorm(n * p), ncol = p)
 beta <- runif(p,min = 0, max = 1)
 y <- as.matrix(x) \%*\% beta + rnorm(50)
 x <- data.frame(x)

 forest <- forestry(x =x,
                    y = y[,1],
                    OOBhonest = TRUE,
                    doubleBootstrap = TRUE)
 p <- predict(forest, x)

 # Corrected predictions
 pred.bc <- correctedPredict(forest,
                             newdata = x,
                             simple = TRUE,
                             nrounds = 0)

}
