% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.rfpred.emp.R
\name{mice.impute.rfpred.emp}
\alias{mice.impute.rfpred.emp}
\title{Multiple imputation using chained random forests: RfPred.Emp}
\usage{
mice.impute.rfpred.emp(
  y,
  ry,
  x,
  wy = NULL,
  num.trees.cont = 10,
  sym.dist = TRUE,
  emp.err.cont = TRUE,
  alpha.emp = 0,
  pre.boot = TRUE,
  num.threads = NULL,
  ...
)
}
\arguments{
\item{y}{Vector to be imputed.}

\item{ry}{Logical vector of length \code{length(y)} indicating the
the subset \code{y[ry]} of elements in \code{y} to which the imputation
model is fitted. The \code{ry} generally distinguishes the observed
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value
indicates locations in \code{y} for which imputations are created.}

\item{num.trees.cont}{Number of trees to build for continuous variables.
The default is \code{num.trees = 10}.}

\item{sym.dist}{If \code{TRUE}, the empirical distribution of out-of-bag
prediction errors will be assumed to be symmetric; if \code{FALSE}, the
empirical distribution will be kept intact. The default is
\code{sym.dist = TRUE}.
This option is invalid when \code{emp.err.cont = FALSE}.}

\item{emp.err.cont}{If \code{TRUE}, the empirical distribution of out-of-bag
prediction errors will be used for constructing conditional distributions;
if \code{FALSE}, for normality will be assumed for the distribution for the
prediction errors, the variance estimate equals to overall out-of-bag
prediction error, i.e. out-of-bag mean squared error (see Shah et al. 2014).}

\item{alpha.emp}{The "significance level" for the empirical distribution of
out-of-bag prediction errors, can be used for prevention for outliers
(useful for highly skewed variables).
For example, set alpha = 0.05 to use 95\% confidence level.
The default is \code{alpha.emp = 0.0}, and the empirical distribution of
out-of-bag prediction errors will be kept intact.
This option is invalid when \code{emp.err.cont = FALSE}.}

\item{pre.boot}{If \code{TRUE}, bootstrapping prior to imputation will be
performed to perform 'proper' multiple imputation, for accommodating sampling
variation in estimating population regression parameters
(see Shah et al. 2014).
It should be noted that if \code{TRUE}, this option is in effect even if the
number of trees is set to one.}

\item{num.threads}{Number of threads for parallel computing. The default is
\code{num.threads = NULL} and all the processors available can be used.}

\item{...}{Other arguments to pass down.}

\item{num.trees}{Number of trees to build. The default is
\code{num.trees = 10}.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length
\code{sum(wy)}.
}
\description{
Please note that functions with names starting with "mice.impute" are
exported to be visible for the mice sampler functions. Please do not call
these functions directly unless you know exactly what you are doing.

For continuous variables only.

This function is for \code{RfPred.Emp} multiple imputation method, adapter
for \code{mice} samplers. In the \code{mice()} function, set
\code{method = "rfpred.emp"} to call it.

The function performs multiple imputation based on the empirical distribution
of out-of-bag prediction errors of random forests.
}
\details{
\code{RfPred.Emp} imputation sampler.
}
\examples{
# Users can set method = "rfpred.emp" in call to mice to use this method
data("airquality")
impObj <- mice(airquality, method = "rfpred.emp", m = 5,
maxit = 5, maxcor = 1.0, eps = .Machine$double.xmin, printFlag = FALSE)

}
\references{
Hong, Shangzhi, et al. "Multiple imputation using chained random forests."
Preprint, submitted April 30, 2020. https://arxiv.org/abs/2004.14823.

Zhang, Haozhe, et al. "Random Forest Prediction Intervals."
The American Statistician (2019): 1-20.

Shah, Anoop D., et al. "Comparison of random forest and parametric
imputation models for imputing missing data using MICE: a CALIBER study."
American journal of epidemiology 179.6 (2014): 764-774.

Malley, James D., et al. "Probability machines." Methods of information
in medicine 51.01 (2012): 74-81.
}
\author{
Shangzhi Hong
}
