% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAncStatesPie.R
\name{plotAncStatesPie}
\alias{plotAncStatesPie}
\title{plot Ancestral States Pie}
\usage{
plotAncStatesPie(
  t,
  cladogenetic = FALSE,
  tip_labels = TRUE,
  tip_labels_size = 2,
  tip_labels_offset = 1,
  tip_labels_italics = FALSE,
  tip_labels_formatted = FALSE,
  tip_labels_remove_underscore = TRUE,
  tip_labels_states = FALSE,
  tip_labels_states_size = 2,
  tip_labels_states_offset = 0.1,
  node_labels_as = NULL,
  node_labels_size = 2,
  node_labels_offset = 0.1,
  pie_colors = "default",
  node_pie_size = 1,
  shoulder_pie_size = node_pie_size,
  tip_pies = TRUE,
  tip_pie_size = 0.5,
  node_pie_nudge_x = 0,
  node_pie_nudge_y = 0,
  tip_pie_nudge_x = node_pie_nudge_x,
  tip_pie_nudge_y = node_pie_nudge_y,
  shoulder_pie_nudge_x = node_pie_nudge_x,
  shoulder_pie_nudge_y = node_pie_nudge_y,
  state_transparency = 0.75,
  timeline = FALSE,
  geo = timeline,
  geo_units = list("epochs", "periods"),
  time_bars = timeline,
  ...
)
}
\arguments{
\item{t}{(treedata object; none) Output of processAncStates() function
containing tree and ancestral states.}

\item{cladogenetic}{(logical; FALSE) Plot shoulder pies of cladogenetic
analyses?}

\item{tip_labels}{(logical; TRUE) Label taxa labels at tips?}

\item{tip_labels_size}{(numeric; 2) Size of tip labels.}

\item{tip_labels_offset}{(numeric; 1) Horizontal offset of tip labels from
tree.}

\item{tip_labels_italics}{(logical; FALSE) Italicize tip labels?}

\item{tip_labels_formatted}{(logical; FALSE) Do the tip labels contain 
manually added formatting information? Will set parse = TRUE in geom_text()
and associated functions to interpret formatting. See ?plotmath for more.
Cannot be TRUE if tip_labels_italics = TRUE.}

\item{tip_labels_remove_underscore}{(logical; TRUE) Remove underscores from
tip labels?}

\item{tip_labels_states}{(logical; FALSE) Optional plotting of text at tips
in addition to taxa labels. Will plot the MAP state label.}

\item{tip_labels_states_size}{(numeric; 2) Size of state labels at tips.
Ignored if tip_labels_states is FALSE.}

\item{tip_labels_states_offset}{(numeric; 0.1) Horizontal offset of tip
state labels. Ignored if tip_labels_states = NULL.}

\item{node_labels_as}{(character; NULL) Optional plotting of text at nodes.
Possible values are "state" for the MAP ancestral states, "node_posterior"
for the posterior probability of the node on the tree, “state_posterior” 
for the posterior probability of the MAP, or NULL for not plotting any
text at the nodes (default).}

\item{node_labels_size}{(numeric; 2) Size of node labels text. Ignored if
node_labels_as = NULL.}

\item{node_labels_offset}{(numeric; 0.1) Horizontal offset of node labels
from nodes. Ignored if node_labels_as = NULL.}

\item{pie_colors}{("character"; "default") Colors for states in pies.
If "default", plots the default RevGadgets colors. Provide a character
vector of hex codes or other R-readable colors the same length of the number
of character states. Names of the vector should correspond to state labels.}

\item{node_pie_size}{(numeric; 1) Size (diameter) of the pies at nodes.}

\item{shoulder_pie_size}{(numeric; node_pie_size) Size (diameter) of the
pies at shoulders for cladogenetic plots.}

\item{tip_pies}{(logical; TRUE) Plot pies tips?}

\item{tip_pie_size}{(numeric; 0.5) Size (diameter) of the pies at tips.}

\item{node_pie_nudge_x}{(numeric; 0) If pies aren't centered, adjust by
nudging}

\item{node_pie_nudge_y}{(numeric; 0) If pies aren't centered, adjust by
nudging}

\item{tip_pie_nudge_x}{(numeric; node_pie_nudge_x) If pies aren't centered,
adjust by nudging}

\item{tip_pie_nudge_y}{(numeric; node_pie_nudge_y) If pies aren't centered,
adjust by nudging}

\item{shoulder_pie_nudge_x}{(numeric; node_pie_nudge_x) If pies aren't
centered, adjust by nudging}

\item{shoulder_pie_nudge_y}{(numeric; node_pie_nudge_y) If pies aren't
centered, adjust by nudging}

\item{state_transparency}{(integer; 0.75) Alpha (transparency) of state
symbols- varies from 0 to 1.}

\item{timeline}{(logical; FALSE) Plot tree with labeled x-axis with
timescale in MYA.}

\item{geo}{(logical; timeline) Add a geological timeline? Defaults to the
same as timeline.}

\item{geo_units}{(list; list("epochs", "periods")) Which geological units to
include in the geo timescale. May be "periods", "epochs", "stages", "eons", 
"eras", or a list of two of those units.}

\item{time_bars}{(logical; timeline) Add vertical gray bars to indicate
geological timeline units if geo == TRUE or regular time intervals (in MYA)
if geo == FALSE.}

\item{...}{(various) Additional arguments passed to ggtree::ggtree().}
}
\value{
A ggplot object
}
\description{
Plot character states and posterior probabilities as pies on nodes.
}
\examples{

\donttest{

# Standard ancestral state reconstruction example

# process file and assign state labels
file <- system.file("extdata",
                    "comp_method_disc/ase_freeK.tree",
                    package="RevGadgets")
example <- processAncStates(file,
                            state_labels = c("1" = "Awesome",
                                             "2" = "Beautiful",
                                             "3" = "Cool!"))
# plot (this may take a while)
plotAncStatesPie(t = example)

# DEC Biogeographic range evolution example (with timeline)

# process file
file <- system.file("extdata", "dec/simple.ase.tre", package="RevGadgets")

# labels that correspond to each region/ possible combination of regions
labs <- c("1" = "K", "2" = "O", "3" = "M", "4" = "H", "5" = "KO",
          "6" = "KM", "7" = "OM", "8" = "KH", "9" = "OH", "10" = "MH",
          "11" = "KOM", "12" = "KOH", "13" = "KMH", "14" = "OMH",
          "15" = "KOMH")
dec_example  <- processAncStates(file , state_labels = labs)
# Use the state_labels in returned tidytree object to define color palette
# These state_labels may be a subset of the labels you provided
# (not all possible regions may be sampled in the dataset)
colors <- colorRampPalette(colFun(12))(length(dec_example@state_labels))
names(colors) <- dec_example@state_labels

# plot
plotAncStatesPie(t = dec_example, pie_colors = colors, tip_labels_size = 3,
        cladogenetic = TRUE, tip_labels_offset = 0.25, timeline = TRUE,
        geo = FALSE) +
        ggplot2::theme(legend.position = c(0.1, 0.75))
}

}
