% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adf_gof.R
\docType{methods}
\name{adf_gof}
\alias{adf_gof}
\title{Goodness of fit of the Angular Dependence function estimates}
\usage{
adf_gof(adf, ray, blocksize = 1, nboot = 250, alpha = 0.05)
}
\arguments{
\item{adf}{An S4 object of class \code{adf_est.class}. See \code{\link{adf_est}} for more details.}

\item{ray}{Ray \mjeqn{\omega}{} to be considered on the goodness of fit assessment.}

\item{blocksize}{Size of the blocks for the block bootstrap procedure. If \code{1} (default), then a standard bootstrap approach is applied.}

\item{nboot}{Number of bootstrap samples to be taken. Default is \code{250} samples.}

\item{alpha}{Significance level to compute the \mjeqn{(1-\alpha)}{}\% tolerance intervals. Default is \code{0.05}.}
}
\value{
An object of S4 class \code{adf_gof.class}. This object returns the arguments of the function and an extra slot \code{gof} which is a list containing: 
\item{model}{A vector containing the model quantiles.} 
\item{empirical}{A vector containing the empirical quantiles.}
\item{lower}{A vector containing the lower bound of the tolerance interval.}
\item{upper}{A vector containing the upper bound of the tolerance interval.}
}
\description{
\loadmathjax{}
Assessment of the goodness of fit of the angular dependence function estimates \mjeqn{\lambda(\omega)}{} following the procedure of \insertCite{MurphyBarltropetal2024;textual}{ReturnCurves}.
}
\details{
Define the min-projection variable as \mjeqn{t^1_\omega = t_\omega - u_\omega | t_\omega > u_\omega}{}, then
variable \mjeqn{\lambda(\omega)T^1_\omega \sim Exp(1)}{} as \mjeqn{u_\omega \to \infty}{} for all \mjeqn{\omega \in [0,1]}{}. 

Let \mjeqn{F^{-1}_E}{} denote the inverse of the cumulative distribution function of a standard exponential variable and \mjeqn{T^1_{(i)}}{} denote the \mjeqn{i}{i}-th ordered increasing statistic, \mjeqn{i = 1, \ldots, n}{}. 
Function \code{plot} shows a QQ plot between the model and empirical exponential quantiles, i.e. points \mjeqn{\left(F^{-1}_E\left(\frac{i}{n+1}\right), T^1_{(i)}\right)}{},
along with the line \mjeqn{y=x}{}. Uncertainty is obtained via a (block) bootstrap procedure and shown by the grey region on the plot.
A good fit is shown by agreement of model and empirical quantiles, i.e. points should lie close to the line \mjeqn{y=x}{}. 
In addition, line \mjeqn{y = x}{} should mainly lie within the \mjeqn{(1-\alpha)}{}\% tolerance intervals.

We note that, if the grid for \mjeqn{\omega}{} used to estimate the Angular Dependence Function (ADF) does not contain \code{ray}, then the closest \mjeqn{\omega}{w} in the grid is used to assess the goodness-of-fit of the ADF.
}
\note{
It is recommended to assess the goodness-of-fit of \mjeqn{\lambda(\omega)}{} for a few values of \mjeqn{\omega}{w}.
}
\examples{
library(ReturnCurves)

data(airdata)

n <- dim(airdata)[1]

margdata <- margtransf(airdata)

lambda <- adf_est(margdata = margdata, method = "hill")

# blocksize to account for temporal dependence
gof <- adf_gof(adf = lambda, ray = 0.4, blocksize = 10)

plot(gof)

# To see the the S4 object's slots
str(gof)

# To access the list of vectors
gof@gof

}
\references{
\insertAllCited{}
}
