% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORSMiddleware.R
\docType{data}
\name{CORSMiddleware}
\alias{CORSMiddleware}
\title{Creates CORS middleware object}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
Adds CORS to \link{Application}. CORS Middleware out of the box in RestRserve to turn on/off the CORS
Headers on preflight validation from the browser. \cr

Cross Origin Resource Sharing is an additional security check done by moderns
browsers to avoid request between different domains. To allow it RestRserve
has easy way to enable your CORS policies. By default CORS policies are disabled.
So if any request is coming from a different domain will be blocked
by the browser as default because RestRserve will not send the headers required
by the browser to allow cross site resource sharing. You can change this easy
just by providing \code{CORSMiddleware} as middleware to the \link{Application}.

This class inherits from \link{Middleware}.
}
\section{Construction}{
\preformatted{CORSMiddleware$new(routes, match = "exact", id = "CORSMiddleware")
}
\itemize{
\item \code{routes} :: \code{character()}\cr
Routes paths to protect.
\item \code{match} :: \code{character()}\cr
How routes will be matched: exact or partial (as prefix).
\item \code{id} :: \code{character(1)}\cr
Middleware id
}
}

\examples{
app = Application$new(middleware = list(CORSMiddleware$new()))
app$add_post(path = "/hello", FUN = function(req, res) {
  res$set_body("Hello from RestRserve!")
})
app$add_route("/hello", method = "OPTIONS", FUN = function(req, res) {
 res$set_header("Allow", "POST, OPTIONS")
})
req = Request$new(
  path = "/hello",
  headers = list("Access-Control-Request-Method" = "POST"),
  method = "OPTIONS"
)
app$process_request(req)

}
\references{
\href{https://developer.mozilla.org/en/docs/Web/HTTP/CORS}{MDN}
}
\seealso{
\link{Middleware} \link{Application}
}
\keyword{datasets}
