/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.listnumbering.AbstractListNumberingDefinition;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.listnumbering.ListLevel;
import org.docx4j.model.listnumbering.ListNumberingDefinition;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.InvalidOperationException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.Style;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumberingDefinitionsPart
extends JaxbXmlPartXPathAware<Numbering> {
    private static Logger log = LoggerFactory.getLogger(NumberingDefinitionsPart.class);
    HashMap<String, AbstractListNumberingDefinition> abstractListDefinitions;
    HashMap<String, ListNumberingDefinition> instanceListDefinitions;
    private Emulator em;

    public NumberingDefinitionsPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public NumberingDefinitionsPart() throws InvalidFormatException {
        super(new PartName("/word/numbering.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/numbering");
    }

    public HashMap<String, AbstractListNumberingDefinition> getAbstractListDefinitions() {
        if (this.abstractListDefinitions == null) {
            this.initialiseMaps();
        }
        return this.abstractListDefinitions;
    }

    public HashMap<String, ListNumberingDefinition> getInstanceListDefinitions() {
        if (this.instanceListDefinitions == null) {
            this.initialiseMaps();
        }
        return this.instanceListDefinitions;
    }

    public void initialiseMaps() {
        Numbering numbering = (Numbering)this.getJaxbElement();
        if (numbering.getNum().size() == 0) {
            log.debug("No num defined");
        }
        this.abstractListDefinitions = new HashMap(numbering.getAbstractNum().size());
        this.instanceListDefinitions = new HashMap(numbering.getNum().size());
        for (Numbering.AbstractNum abstractNumNode : numbering.getAbstractNum()) {
            AbstractListNumberingDefinition absNumDef = new AbstractListNumberingDefinition(abstractNumNode);
            this.abstractListDefinitions.put(absNumDef.getID(), absNumDef);
        }
        for (Numbering.Num numNode : numbering.getNum()) {
            ListNumberingDefinition listDef = new ListNumberingDefinition(numNode, this.abstractListDefinitions);
            this.instanceListDefinitions.put(listDef.getListNumberId(), listDef);
        }
    }

    public void resolveLinkedAbstractNum(StyleDefinitionsPart sdp) {
        if (sdp == null) {
            log.warn("No StyleDefinitionsPart found");
            return;
        }
        for (Numbering.AbstractNum abstractNum : ((Numbering)this.getJaxbElement()).getAbstractNum()) {
            if (abstractNum.getNumStyleLink() == null) continue;
            String numStyleId = abstractNum.getNumStyleLink().getVal();
            Style s = sdp.getStyleById(numStyleId);
            if (s == null) {
                log.warn("For w:numStyleLink, couldn't find style " + numStyleId);
                continue;
            }
            if (s.getPPr() == null || s.getPPr().getNumPr() == null) {
                log.warn("For w:numStyleLink, style " + numStyleId + " has no w:numPr");
                continue;
            }
            PPrBase.NumPr styleNumPr = s.getPPr().getNumPr();
            if (styleNumPr.getNumId() == null) {
                log.warn("For w:numStyleLink, style " + numStyleId + " w:numPr has no w:numId");
                continue;
            }
            BigInteger concreteListId = styleNumPr.getNumId().getVal();
            ListNumberingDefinition lnd = this.getInstanceListDefinitions().get(concreteListId.toString());
            if (lnd == null) {
                log.warn("No ListNumberingDefinition entry with ID " + concreteListId.toString());
            }
            Numbering.AbstractNum linkedNum = lnd.getAbstractListDefinition().getAbstractNumNode();
            AbstractListNumberingDefinition absNumDef = this.abstractListDefinitions.get(abstractNum.getAbstractNumId().toString());
            absNumDef.updateDefinitionFromLinkedStyle(linkedNum);
            if (abstractNum.getLvl().size() > 0) {
                log.warn("Cowardly refusing to overwrite existing List<Lvl>");
            } else {
                abstractNum.getLvl().clear();
                abstractNum.getLvl().addAll(linkedNum.getLvl());
            }
            log.info("Updated abstract list def " + abstractNum.getAbstractNumId().toString() + " based on w:numStyleLink " + numStyleId);
        }
    }

    public long restart(long numId, long ilvl, long val) throws InvalidOperationException {
        ListNumberingDefinition existingLnd;
        if (this.em == null) {
            this.getEmulator();
        }
        if ((existingLnd = this.instanceListDefinitions.get(Long.toString(numId))) == null) {
            throw new InvalidOperationException("List " + numId + " does not exist");
        }
        BigInteger abstractNumIdVal = existingLnd.getNumNode().getAbstractNumId().getVal();
        long newNumId = this.instanceListDefinitions.size() + 1;
        ObjectFactory factory = Context.getWmlObjectFactory();
        Numbering.Num newNum = factory.createNumberingNum();
        newNum.setNumId(BigInteger.valueOf(newNumId));
        Numbering.Num.AbstractNumId abstractNumId = factory.createNumberingNumAbstractNumId();
        abstractNumId.setVal(abstractNumIdVal);
        newNum.setAbstractNumId(abstractNumId);
        Numbering.Num.LvlOverride lvlOverride = factory.createNumberingNumLvlOverride();
        lvlOverride.setIlvl(BigInteger.valueOf(ilvl));
        newNum.getLvlOverride().add(lvlOverride);
        Numbering.Num.LvlOverride.StartOverride start = factory.createNumberingNumLvlOverrideStartOverride();
        start.setVal(BigInteger.valueOf(val));
        lvlOverride.setStartOverride(start);
        ((Numbering)this.getJaxbElement()).getNum().add(newNum);
        ListNumberingDefinition listDef = new ListNumberingDefinition(newNum, this.abstractListDefinitions);
        this.instanceListDefinitions.put(listDef.getListNumberId(), listDef);
        return newNumId;
    }

    public Emulator getEmulator() {
        return this.getEmulator(false);
    }

    public Emulator getEmulator(boolean reset) {
        if (this.em == null || reset) {
            this.initialiseMaps();
            this.em = new Emulator();
        }
        return this.em;
    }

    public PPrBase.Ind getInd(PPrBase.NumPr numPr) {
        String ilvlString = "0";
        if (numPr.getIlvl() != null) {
            ilvlString = numPr.getIlvl().getVal().toString();
        }
        if (numPr.getNumId() == null) {
            log.warn("numPr without numId: " + XmlUtils.marshaltoString((Object)numPr, true, true));
            return null;
        }
        return this.getInd(numPr.getNumId().getVal().toString(), ilvlString);
    }

    public PPrBase.Ind getInd(String numId, String ilvl) {
        PPrBase.Ind ind;
        ListLevel ll;
        ListNumberingDefinition lnd = this.getInstanceListDefinitions().get(numId);
        if (lnd == null) {
            log.debug("couldn't find list for numId: " + numId);
            return null;
        }
        if (ilvl == null) {
            ilvl = "0";
        }
        if ((ll = lnd.getLevel(ilvl)) == null) {
            log.warn("No ListLevel defined for level " + ilvl + " in list " + numId);
            return null;
        }
        Lvl jaxbOverrideLvl = ll.getJaxbOverrideLvl();
        log.debug("Looking at override/instance definition..");
        if (jaxbOverrideLvl != null && (ind = this.getIndFromLvl(jaxbOverrideLvl)) != null) {
            log.debug("Got it..");
            return ind;
        }
        log.debug("Looking at abstract definition..");
        Lvl abstractLvl = ll.getJaxbAbstractLvl();
        PPrBase.Ind ind2 = this.getIndFromLvl(abstractLvl);
        return ind2;
    }

    private PPrBase.Ind getIndFromLvl(Lvl lvl) {
        if (lvl.getPStyle() != null) {
            PropertyResolver propertyResolver = ((WordprocessingMLPackage)this.getPackage()).getMainDocumentPart().getPropertyResolver();
            log.debug("override level has linked style: " + lvl.getPStyle().getVal());
            Style style = propertyResolver.getStyle(lvl.getPStyle().getVal());
            if (style == null) {
                log.error("Couldn't find style " + lvl.getPStyle().getVal());
                return null;
            }
            if (style.getPPr() != null && style.getPPr().getInd() != null) {
                return style.getPPr().getInd();
            }
        }
        if (lvl.getPPr() != null && lvl.getPPr().getInd() != null) {
            return lvl.getPPr().getInd();
        }
        return null;
    }

    public Numbering.Num addAbstractListNumberingDefinition(Numbering.AbstractNum abstractNum) {
        int nextId = this.getAbstractListDefinitions().size();
        while (this.getAbstractListDefinitions().containsKey("" + ++nextId)) {
        }
        abstractNum.setAbstractNumId(BigInteger.valueOf(nextId));
        ((Numbering)this.getJaxbElement()).getAbstractNum().add(abstractNum);
        AbstractListNumberingDefinition absNumDef = new AbstractListNumberingDefinition(abstractNum);
        this.abstractListDefinitions.put(absNumDef.getID(), absNumDef);
        Numbering.Num num = Context.getWmlObjectFactory().createNumberingNum();
        Numbering.Num.AbstractNumId abstractNumId = Context.getWmlObjectFactory().createNumberingNumAbstractNumId();
        abstractNumId.setVal(BigInteger.valueOf(nextId));
        num.setAbstractNumId(abstractNumId);
        nextId = this.getInstanceListDefinitions().size();
        while (this.getInstanceListDefinitions().containsKey("" + ++nextId)) {
        }
        num.setNumId(BigInteger.valueOf(nextId));
        ((Numbering)this.getJaxbElement()).getNum().add(num);
        ListNumberingDefinition listDef = new ListNumberingDefinition(num, this.abstractListDefinitions);
        this.instanceListDefinitions.put(listDef.getListNumberId(), listDef);
        return num;
    }

    public Numbering unmarshalDefaultNumbering() throws JAXBException {
        InputStream is = null;
        try {
            is = ResourceUtils.getResource("org/docx4j/openpackaging/parts/WordprocessingML/numbering.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (Numbering)this.unmarshal(is);
    }
}

