/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.DrawingML;

import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.XmlUtils;
import org.docx4j.dml.diagram.CTDiagramDefinition;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.DrawingML.CreateWithSmartArtAbstract;
import org.docx4j.openpackaging.parts.DrawingML.DiagramColorsPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramDataPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramLayoutPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramStylePart;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.utils.ResourceUtils;
import org.glox4j.openpackaging.packages.GloxPackage;
import org.pptx4j.jaxb.Context;
import org.pptx4j.model.SlideSizesWellKnown;
import org.pptx4j.pml.CTGraphicalObjectFrame;
import org.pptx4j.pml.Presentation;
import org.pptx4j.pml.Sld;
import org.w3c.dom.Document;

public class CreatePptxWithSmartArt
extends CreateWithSmartArtAbstract {
    public CreatePptxWithSmartArt(CTDiagramDefinition diagramLayoutObj, Templates layoutTreeCreatorXslt, Templates layoutTree2DiagramDataXslt) {
        super(diagramLayoutObj, layoutTreeCreatorXslt, layoutTree2DiagramDataXslt);
    }

    public PresentationMLPackage createSmartArtPkg(SlideSizesWellKnown sz, boolean landscape, Document xml) throws Exception {
        PresentationMLPackage pMLPackage = PresentationMLPackage.createPackage(sz, landscape);
        MainPresentationPart pp = (MainPresentationPart)pMLPackage.getParts().getParts().get(new PartName("/ppt/presentation.xml"));
        SlideLayoutPart layoutPart = (SlideLayoutPart)pMLPackage.getParts().getParts().get(new PartName("/ppt/slideLayouts/slideLayout1.xml"));
        SlidePart slidePart = PresentationMLPackage.createSlidePart(pp, layoutPart, new PartName("/ppt/slides/slide1.xml"));
        DiagramLayoutPart layout = new DiagramLayoutPart(new PartName("/ppt/diagrams.layout1.xml"));
        layout.setJaxbElement(this.diagramLayoutObj);
        DiagramColorsPart colors = new DiagramColorsPart(new PartName("/ppt/diagrams.colors1.xml"));
        colors.unmarshal("colorsDef-accent1_2.xml");
        DiagramStylePart style = new DiagramStylePart(new PartName("/ppt/diagrams.quickStyle1.xml"));
        style.unmarshal("quickStyle-simple1.xml");
        DiagramDataPart data = new DiagramDataPart(new PartName("/ppt/diagrams.data1.xml"));
        data.setPackage(pMLPackage);
        data.setJaxbElement(this.createDiagramData(data, xml));
        String layoutRelId = slidePart.addTargetPart(layout).getId();
        String dataRelId = slidePart.addTargetPart(data).getId();
        String colorsRelId = slidePart.addTargetPart(colors).getId();
        String styleRelId = slidePart.addTargetPart(style).getId();
        Presentation.SldSz tmpSldSz = ((Presentation)pMLPackage.getMainPresentationPart().getJaxbElement()).getSldSz();
        CTGraphicalObjectFrame graphicFrame = CreatePptxWithSmartArt.createSmartArt(layoutRelId, dataRelId, colorsRelId, styleRelId, "" + (tmpSldSz.getCx() - 200000), "" + (tmpSldSz.getCy() - 1000000));
        ((Sld)slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(graphicFrame);
        return pMLPackage;
    }

    public static CTGraphicalObjectFrame createSmartArt(String layoutRelId, String dataRelId, String colorsRelId, String styleRelId, String cx, String cy) throws Exception {
        String ml = "<p:graphicFrame   xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"><p:nvGraphicFramePr><p:cNvPr id=\"4\" name=\"Diagram 3\"/><p:cNvGraphicFramePr/><p:nvPr/></p:nvGraphicFramePr><p:xfrm><a:off x=\"100000\" y=\"900000\"/><a:ext cx=\"${cx}\" cy=\"${cy}\"/></p:xfrm><a:graphic><a:graphicData uri=\"http://schemas.openxmlformats.org/drawingml/2006/diagram\"><dgm:relIds  r:dm=\"${dataRelId}\" r:lo=\"${layoutRelId}\" r:qs=\"${styleRelId}\" r:cs=\"${colorsRelId}\" xmlns:dgm=\"http://schemas.openxmlformats.org/drawingml/2006/diagram\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" /></a:graphicData></a:graphic></p:graphicFrame>";
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("layoutRelId", layoutRelId);
        mappings.put("dataRelId", dataRelId);
        mappings.put("colorsRelId", colorsRelId);
        mappings.put("styleRelId", styleRelId);
        mappings.put("cx", cx);
        mappings.put("cy", cy);
        return (CTGraphicalObjectFrame)XmlUtils.unmarshallFromTemplate(ml, mappings, Context.jcPML, CTGraphicalObjectFrame.class);
    }

    public static void main(String[] args) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(System.getProperty("user.dir") + "/sample-docs/glox/extracted/data-sample.xml"));
        GloxPackage gloxPackage = (GloxPackage)OpcPackage.load(new File(System.getProperty("user.dir") + "/sample-docs/glox/extracted/CirclePictureHierarchy.glox"));
        CTDiagramDefinition diagramLayoutObj = (CTDiagramDefinition)gloxPackage.getDiagramLayoutPart().getJaxbElement();
        Templates layoutTreeCreatorXslt = DiagramLayoutPart.generateLayoutTreeXSLT(diagramLayoutObj);
        Templates layoutTree2DiagramDataXslt = XmlUtils.getTransformerTemplate(new StreamSource(ResourceUtils.getResource("org/docx4j/openpackaging/parts/DrawingML/DiagramLayoutTree4AlgHier.xslt")));
        CreatePptxWithSmartArt creatorPptx = new CreatePptxWithSmartArt(diagramLayoutObj, layoutTreeCreatorXslt, layoutTree2DiagramDataXslt);
        PresentationMLPackage pkg = creatorPptx.createSmartArtPkg(SlideSizesWellKnown.A3, true, doc);
        SaveToZipFile saver = new SaveToZipFile(pkg);
        saver.save(new File(System.getProperty("user.dir") + "/OUT.pptx"));
        System.out.println("Done!");
    }
}

