/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class RationalNumber
extends Number {
    private static final long serialVersionUID = -1L;
    public final int numerator;
    public final int divisor;
    private static final NumberFormat nf = DecimalFormat.getInstance();

    public RationalNumber(int numerator, int divisor) {
        this.numerator = numerator;
        this.divisor = divisor;
    }

    public static final RationalNumber factoryMethod(long n, long d) {
        if (n > Integer.MAX_VALUE || n < Integer.MIN_VALUE || d > Integer.MAX_VALUE || d < Integer.MIN_VALUE) {
            while ((n > Integer.MAX_VALUE || n < Integer.MIN_VALUE || d > Integer.MAX_VALUE || d < Integer.MIN_VALUE) && Math.abs(n) > 1L && Math.abs(d) > 1L) {
                n >>= 1;
                d >>= 1;
            }
            if (d == 0L) {
                throw new NumberFormatException("Invalid value, numerator: " + n + ", divisor: " + d);
            }
        }
        long gcd = RationalNumber.gcd(n, d);
        return new RationalNumber((int)(n /= gcd), (int)(d /= gcd));
    }

    private static long gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return RationalNumber.gcd(b, a % b);
    }

    public RationalNumber negate() {
        return new RationalNumber(-this.numerator, this.divisor);
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.divisor;
    }

    public float floatValue() {
        return (float)this.numerator / (float)this.divisor;
    }

    public int intValue() {
        return this.numerator / this.divisor;
    }

    public long longValue() {
        return (long)this.numerator / (long)this.divisor;
    }

    public boolean isValid() {
        return this.divisor != 0;
    }

    public String toString() {
        if (this.divisor == 0) {
            return "Invalid rational (" + this.numerator + "/" + this.divisor + ")";
        }
        if (this.numerator % this.divisor == 0) {
            return nf.format(this.numerator / this.divisor);
        }
        return this.numerator + "/" + this.divisor + " (" + nf.format((double)this.numerator / (double)this.divisor) + ")";
    }

    public String toDisplayString() {
        if (this.numerator % this.divisor == 0) {
            return "" + this.numerator / this.divisor;
        }
        NumberFormat nf = DecimalFormat.getInstance();
        nf.setMaximumFractionDigits(3);
        return nf.format((double)this.numerator / (double)this.divisor);
    }
}

