/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.tables;

import java.math.BigInteger;
import java.util.LinkedHashMap;

import javax.xml.bind.JAXBElement;

import org.docx4j.dml.CTTableRow;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.wml.CTHeight;
import org.docx4j.wml.STHeightRule;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;

public class FlexRow extends DocComponent implements HTML4R{
	
	private LinkedHashMap<Integer, FlexCell> cellList;
	private int rowheight;
	
	public FlexRow(){
		cellList = new LinkedHashMap<Integer, FlexCell>();
		rowheight = -1;
	}
	public FlexRow(int height){
		cellList = new LinkedHashMap<Integer, FlexCell>();
		rowheight = height;
	}
	public void add(FlexCell fc){
		cellList.put(size(), fc);
	}
	public void add(FlexCell fc, int i){
		cellList.put(i, fc);
	}
	public int size(){
		return cellList.size() ;
	}
	public int weight(){
		int out = 0;
		if( size() > 0 )
			for(int i = 0 ; i < size()  ; i++ ){
				out += cellList.get(i).getColspan();
			}
		
		return out ;
	}
	public int rowHeight(){
		return rowheight ;
	}
	public FlexCell getCell(int index){
		return cellList.get(index);
	}
	public boolean hasCell(int index){
		return cellList.containsKey(index);
	}
	
	public int getCellIDCellAt(int index){
		int cell_id = 0;
		int colspan_curr = 0;
		while( true ){
			if( hasCell( cell_id ) ){
				colspan_curr += getCell( cell_id ).getColspan();
			}
			if( colspan_curr > index ) break;
			cell_id++;
		}

		return cell_id;
	}
	public boolean hasCellAt(int index){
		int cell_id = 0;
		int colspan_curr = 0;
		while( true ){
			if( hasCell( cell_id ) ){
				colspan_curr += getCell( cell_id ).getColspan();
			}
			if( colspan_curr > index ) return true;
			if( !hasCell( cell_id + 1 ) ) return false;
			cell_id++;
		}
		
	}
	

	public String toString(){
		String out = "";
		if( size() > 0 )
			for(int i = 0 ; i < size()  ; i++ ){
				out += cellList.get(i).toString();
			}
		return out;
	}

	@Override
	public String getHTML() {
		
		
		String out = "<tr>";
		for( int i = 0 ; i < size() ; i++ ){
			out += cellList.get(i).getHTML();
		}
			
		out += "</tr>";
		
		return out;
	}

	public Tr getTr() throws Exception{
		Tr workingRow = new Tr();
		boolean ishoriz = true;
		for( int i = 0 ; i < size() ; i++ ){
			cellList.get(i).setNumberingDefinitionsPart(ndp);
			cellList.get(i).setOrderedNumID(ordered_num_id);
			cellList.get(i).setUnorderedNumID(unordered_num_id);
			cellList.get(i).setDOCXMLPackage(getDOCXMLPackage());
			cellList.get(i).getParagraphsSection().getParProperties().setUnorderedNumid(unordered_num_id);
			cellList.get(i).getParagraphsSection().getParProperties().setOrderedNumid(ordered_num_id);
			workingRow.getContent().add(cellList.get(i).getTc());
			if( !cellList.get(i).horizontalText() ) 
				ishoriz = false;
		}
		

		if( rowheight > 0 && !ishoriz ){
			CTHeight ctHeight = new CTHeight();
			ctHeight.setHRule(STHeightRule.AT_LEAST);
			ctHeight.setVal(BigInteger.valueOf((long)(rowheight*20)));
			JAXBElement<CTHeight> jaxbElement = Context.getWmlObjectFactory().createCTTrPrBaseTrHeight(ctHeight);
			TrPr trPr = new TrPr();
			trPr.getCnfStyleOrDivIdOrGridBefore().add(jaxbElement);
			workingRow.setTrPr(trPr);
		}
			
		return workingRow;
	}
	
	public CTTableRow getCTTableRow(SlidePart slidePart) throws Exception{
		CTTableRow workingRow = new CTTableRow();
		boolean ishoriz = true;
//		
		for( int i = 0 ; i < size() ; i++ ){
			FlexCell temp = cellList.get(i);
			temp.setPPTXSlidePart(slidePart);
			
			if( !temp.horizontalText() ) 
				ishoriz = false;
			
			workingRow.getTc().add(temp.getCTTableCell());
			if( temp.getColspan() > 1 ) {
				for(int p = 1 ; p < temp.getColspan() ; p++ ){
					FlexCell temp1 = temp.clone();
					temp1.setColspan(0);
					workingRow.getTc().add( temp1.getCTTableCell() );
				}
			}
			
		}
		if( rowheight > 0 && !ishoriz ){
			workingRow.setH((long)(rowheight*12700));
		}
		return workingRow;
	}
	
	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}
	
}
