\name{addPlot.pptx}
\alias{addPlot.pptx}
\title{Add a plot into a pptx object}
\usage{
\method{addPlot}{pptx}(doc, fun, pointsize = 11, vector.graphic = TRUE,
  fontname = getOption("ReporteRs-default-font"), editable = TRUE, offx,
  offy, width, height, ...)
}
\arguments{
  \item{doc}{\code{\link{pptx}} object}

  \item{fun}{plot function. The function will be executed
  to produce graphics. For \code{grid} or \code{lattice} or
  \code{ggplot} object, the function should just be print
  and an extra argument x should specify the object to
  plot. For traditionnal plots, the function should contain
  plot instructions. See examples.}

  \item{pointsize}{the default pointsize of plotted text,
  interpreted as big points (1/72 inch) at res ppi.}

  \item{vector.graphic}{logical scalar, default to TRUE. If
  TRUE, vector graphics are produced instead of PNG images.
  Vector graphics in pptx document are DrawingML
  instructions.}

  \item{fontname}{the default font family to use, default
  to getOption("ReporteRs-default-font").}

  \item{editable}{logical value - if TRUE vector graphics
  elements (points, text, etc.) are editable.}

  \item{offx}{optional, x position of the shape (top left
  position of the bounding box) in inch. See details.}

  \item{offy}{optional, y position of the shape (top left
  position of the bounding box) in inch. See details.}

  \item{width}{optional, width of the shape in inch. See
  details.}

  \item{height}{optional, height of the shape in inch. See
  details.}

  \item{...}{arguments for \code{fun}.}
}
\value{
an object of class \code{\link{pptx}}.
}
\description{
Add a plot to the current slide of an existing \code{pptx}
object.
}
\details{
If arguments offx, offy, width, height are missing,
position and dimensions will be defined by the width and
height of the next available shape of the slide. This
dimensions can be defined in the layout of the PowerPoint
template used to create the \code{pptx} object.

If arguments offx, offy, width, height are provided, they
become position and dimensions of the new shape.
}
\examples{
\donttest{
doc.filename = "addPlot_example.pptx"

# set default font size to 24
options( "ReporteRs-fontsize" = 24 )

doc = pptx( title = "title" )

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addTitle( doc, "Title example 1" )
# Add a base plot
doc = addPlot( doc, fun = plot
  , x = rnorm( 100 ), y = rnorm (100 )
  , main = "base plot main title"
)
# Add a base plot at a specified location
doc = addPlot( doc, fun = plot
  , x = rnorm( 100 ), y = rnorm (100 ), col = "red"
  , main = "small shape", pointsize=5
  , offx = 7, offy = 0, width = 3, height = 2
)

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )


doc = addTitle( doc, "Title example 2" )
# load ggplot2
if( requireNamespace("ggplot2", quietly = TRUE) ){

  # create a ggplot2 plot
  myplot = ggplot2::qplot(Sepal.Length, Petal.Length, data = iris
    , color = Species, size = Petal.Width, alpha = I(0.7) )

  # Add myplot into object doc
  #   myplot is assigned to argument 'x' because function 'print' on ggplot
  #   objects is expecting argument 'x'.
  doc = addPlot( doc = doc, fun = print, x = myplot )
}

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{pptx}}, \code{\link{addPlot}}
}

