/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docs;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.lysis.reporters.docs.HTMLPageContent;
import org.lysis.reporters.html4r.elements.MenuBar;
import org.lysis.reporters.html4r.tools.utils;

public class html4R {
    private LinkedHashMap<String, HTMLPageContent> pages = new LinkedHashMap();
    private LinkedHashMap<String, String> links = new LinkedHashMap();
    private String title;
    private int index;

    public html4R(String title, String charset) throws IOException {
        this.title = title;
        this.index = 0;
    }

    public void addNewPage(String title, HTMLPageContent page) {
        ++this.index;
        String filename = "page_" + this.index + "_" + utils.generateUniqueId() + ".html";
        this.pages.put(title, page);
        this.links.put(title, filename);
    }

    public int writeDocument(String directory) {
        HTMLPageContent doc;
        MenuBar mb = new MenuBar(this.title);
        for (String id : this.pages.keySet()) {
            mb.addTitle(id, this.links.get(id));
        }
        for (String id : this.pages.keySet()) {
            doc = this.pages.get(id);
            try {
                doc.setMenuBar((MenuBar)mb.clone());
            }
            catch (IOException e) {
                return HTMLPageContent.error;
            }
            try {
                doc.setActiveMenuBarTitle(id);
            }
            catch (IOException e) {
                return HTMLPageContent.error;
            }
        }
        for (String id : this.pages.keySet()) {
            doc = this.pages.get(id);
            try {
                doc.writeHtml(String.valueOf(directory) + "/" + this.links.get(id));
            }
            catch (IOException e) {
                return HTMLPageContent.error;
            }
        }
        return HTMLPageContent.noproblem;
    }
}

