test_that("Output of function 'powerSignificance' stays the same.", {
    zo <- seq(-1, 1, 1)
    grid <- expand.grid(
        priors = c("conditional", "predictive", "EB"),
        c = c(0.5, 2),
        h = c(0, 1),
        alt = c("two.sided", "one.sided"),
        shrinkage = c(0, 0.5),
        stringsAsFactors = FALSE
    )
    out <- lapply(
        X = seq_len(nrow(grid)),
        FUN = function(i) {
        powerSignificance(
            zo = zo,
            c = grid$c[i],
            level = 0.05,
            designPrior = grid$priors[i],
            alternative = grid$alt[i],
            h = grid$h[i],
            shrinkage = grid$shrinkage[i]
        )
    })
    expect_equal(
        out,
        list(
            c(0.105128839609805, 0.025, 0.105128839609805),
            c(0.153164887002923, 0.0547655919261876, 0.153164887002923),
            c(0.025, 0.025, 0.025),
            c(0.29261875345421, 0.025, 0.29261875345421),
            c(0.376346981956041, 0.128904320268035, 0.376346981956041),
            c(0.025, 0.025, 0.025),
            c(0.105128839609805, 0.025, 0.105128839609805),
            c(0.214070597849871, 0.107563528680747, 0.214070597849871),
            c(0.0547655919261876, 0.0547655919261876, 0.0547655919261876),
            c(0.29261875345421, 0.025, 0.29261875345421),
            c(0.418288337676037, 0.229408341649887, 0.418288337676037),
            c(0.128904320268035, 0.128904320268035, 0.128904320268035),
            c(0.174187261617932, 0.05, 0.174187261617932),
            c(0.221937205879032, 0.08963317592404, 0.221937205879032),
            c(0.05, 0.05, 0.05),
            c(0.40879721979387, 0.05, 0.40879721979387),
            c(0.447033381345704, 0.171143362995444, 0.447033381345704),
            c(0.05, 0.05, 0.05),
            c(0.174187261617932, 0.05, 0.174187261617932),
            c(0.276562743130718, 0.149101020851907, 0.276562743130718),
            c(0.08963317592404, 0.08963317592404, 0.08963317592404),
            c(0.40879721979387, 0.05, 0.40879721979387),
            c(0.465266702002727, 0.26707081412311, 0.465266702002727),
            c(0.171143362995444, 0.171143362995444, 0.171143362995444),
            c(0.0540918623618536, 0.025, 0.0540918623618536),
            c(0.0948227125608762, 0.0547655919261876, 0.0948227125608762),
            c(0.025, 0.025, 0.025),
            c(0.105128839609805, 0.025, 0.105128839609805),
            c(0.234736296915959, 0.128904320268035, 0.234736296915959),
            c(0.025, 0.025, 0.025),
            c(0.0540918623618536, 0.025, 0.0540918623618536),
            c(0.154818677461375, 0.107563528680747, 0.154818677461375),
            c(0.0547655919261876, 0.0547655919261876, 0.0547655919261876),
            c(0.105128839609805, 0.025, 0.105128839609805),
            c(0.317915585520223, 0.229408341649887, 0.317915585520223),
            c(0.128904320268035, 0.128904320268035, 0.128904320268035),
            c(0.0982997943579869, 0.05, 0.0982997943579869),
            c(0.145863130961703, 0.08963317592404, 0.145863130961703),
            c(0.05, 0.05, 0.05),
            c(0.174187261617932, 0.05, 0.174187261617932),
            c(0.294113061454605, 0.171143362995444, 0.294113061454605),
            c(0.05, 0.05, 0.05),
            c(0.0982997943579869, 0.05, 0.0982997943579869),
            c(0.207052810036395, 0.149101020851907, 0.207052810036395),
            c(0.08963317592404, 0.08963317592404, 0.08963317592404),
            c(0.174187261617932, 0.05, 0.174187261617932),
            c(0.361506457143659, 0.26707081412311, 0.361506457143659),
            c(0.171143362995444, 0.171143362995444, 0.171143362995444)
        )
    )
})


test_that("numeric test for powerSignificance(): 1", {
    expect_equal(object = powerSignificance(zo = qnorm(p = 1 - 0.05 / 2),
                                            c = 1, level = 0.05,
                                            alternative = "two.sided"),
                 expected = 0.5,
                 tol = 0.0001)
    expect_equal(object = powerSignificance(zo = qnorm(p = 1 - 0.0056 / 2),
                                            c = 1, level = 0.05,
                                            alternative = "two.sided"),
                 expected = 0.791,
                 tol = 0.001)

})


