% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undoShrinkage.R
\name{undoShrinkage}
\alias{undoShrinkage}
\title{Undo shrinkage.}
\usage{
undoShrinkage(DATA, R, Phat, MAXITER)
}
\arguments{
\item{DATA}{The concatenated data block, with rows representing subjects}

\item{R}{The number of components.}

\item{Phat}{The estimated component loading matrix by means of, for example, \code{sparseSCA()}.}

\item{MAXITER}{The maximum rounds of iterations. It should be a positive integer. The default value is 400.}
}
\value{
\item{Pmatrix}{The re-estimated component loading matrix after the shrinkage has been removed.}
\item{Tmatrix}{The corresponding estimated component score matrix.}
\item{Lossvec}{A vector of loss.}
}
\description{
\code{undoShrinkage} re-estimates the component loading matrix (P) while keeping the 0 loadings fixed 
so as to remove the shrinkage due to Lasso and Group Lasso.
}
\references{
Gu, Z., & Van Deun, K. (2016). A variable selection method for simultaneous component based data integration. \emph{Chemometrics and Intelligent Laboratory Systems}, 158, 187-199.
}
