% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegSDCadd.R
\encoding{UTF8}
\name{RegSDCadd}
\alias{RegSDCadd}
\title{Regression-based SDC Tools - Synthetic addition with residual correlation control}
\usage{
RegSDCadd(y, resCorr = NULL, x = NULL, yStart = NULL,
  ensureIntercept = TRUE)
}
\arguments{
\item{y}{Matrix of confidential variables}

\item{resCorr}{Required residual correlations (possibly recycled)}

\item{x}{Matrix of non-confidential variables}

\item{yStart}{Arbitrary data whose residuals will be used. Will be calculated from resCorr when NULL.}

\item{ensureIntercept}{Whether to ensure/include a constant term. Non-NULL x is subjected to \code{\link{EnsureIntercept}}}
}
\value{
Generated version of y with alpha as attribute
}
\description{
Implementation of equation 6 (arbitrary residual data) and equation 7 (residual correlations) in the paper.
The alpha limit is calculated (equation 9). The limit is used when alpha =1 cannot be chosen (warning produced). 
In output, alpha is attribute.
}
\details{
Use epsAlpha=NULL to avoid calculation of alpha. Use of alpha (<1) will produce a warning. Input matrices are subjected to \code{\link{EnsureMatrix}}.
}
\examples{
x <- matrix(1:10, 10, 1)
y <- matrix(rnorm(30) + 1:30, 10, 3)
yOut <- RegSDCadd(y, c(0.1, 0.2, 0.3), x)

# Correlations between residuals as required
diag(cor(residuals(lm(y ~ x)), residuals(lm(yOut ~ x))))

# Identical covariance matrices
cov(y) - cov(yOut)
cov(residuals(lm(y ~ x))) - cov(residuals(lm(yOut ~ x)))

# Identical regression results
summary(lm(y[, 1] ~ x))
summary(lm(yOut[, 1] ~ x))

# alpha as attribute
attr(yOut, "alpha")

# With yStart as input and alpha limit in use (warning produced)
yOut <- RegSDCadd(y, NULL, x, 2 * y + matrix(rnorm(30), 10, 3))
attr(yOut, "alpha")

# Same correlation for all variables
RegSDCadd(y, 0.2, x)
# But in this case RegSDCcomp is equivalent and faster
RegSDCcomp(y, 0.2, x)


# Make nearly collinear data
y[, 3] <- y[, 1] + y[, 2] + 0.001 * y[, 3]
# Not possible to achieve correlations. Small alpha with warning.
RegSDCadd(y, c(0.1, 0.2, 0.3), x)
# Exact collinear data
y[, 3] <- y[, 1] + y[, 2]
# Zero alpha with warning
RegSDCadd(y, c(0.1, 0.2, 0.3), x)
}
