% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/I.record.R
\name{I.record}
\alias{I.record}
\alias{I.record.default}
\alias{I.record.numeric}
\alias{I.record.matrix}
\title{Record Indicator random variables}
\usage{
I.record(XM_T, record = c("upper", "lower"))

\method{I.record}{default}(XM_T, record = c("upper", "lower"))

\method{I.record}{numeric}(XM_T, record = c("upper", "lower"))

\method{I.record}{matrix}(XM_T, record = c("upper", "lower"))
}
\arguments{
\item{XM_T}{A numeric vector, matrix (or data frame).}

\item{record}{A character string indicating the type of record to be 
calculated, "upper" or "lower".}
}
\value{
A binary matrix, indicating the record occurrence.
}
\description{
This function calculates for each value in the vector a binary 
  variable which takes the value 1 if the corresponding value in the vector 
  is a record and 0 otherwise. If the argument \code{XM_T} is a matrix, 
  each column is treated as a different vector.
}
\details{
Let \eqn{\{X_1,\ldots,X_T\}} be a sequence of random variables of 
  size \eqn{T}. An observation \eqn{X_t} will be called an upper record 
  value if its value exceeds that of all previous observations. An 
  analogous definition deals with lower record values.
  Here \eqn{X_1} is referred to as the reference value or the trivial record.
  Then, the sequence of record indicator random variables 
  \eqn{\{I_1,\ldots,I_T\}} is given by
      \deqn{I_t = \left\{ 
        \begin{array}{ll} 
          1 & \mbox{if } X_t \mbox{ is a record,} \\ 
          0 & \mbox{if } X_t \mbox{ is not a record.} 
        \end{array} \right.} 

  The method \code{I.record} calculates the sample sequence above if the 
  argument \code{XM_T} is a numeric vector. If the argument \code{XM_T} is a 
  matrix (or data frame) with \eqn{M} columns, the method \code{I.record} 
  calculates the sample sequence above for each column of the object as if 
  all columns were different sequences.
 
  Summarily:
  \deqn{\code{I.record}: \code{XM\_T} = \left(
                 \begin{array}{cccc} 
                   X_{1,1} & X_{1,2} & \cdots & X_{1,M} \\ 
                   X_{2,1} & X_{2,2} & \cdots & X_{2,M} \\ 
                   \vdots & \vdots &  & \vdots \\ 
                   X_{T,1} & X_{T,2} & \cdots & X_{T,M} \\ 
                 \end{array} \right) 
                 \longrightarrow
                 \left(
                 \begin{array}{cccc} 
                   I_{1,1} & I_{1,2} & \cdots & I_{1,M} \\ 
                   I_{2,1} & I_{2,2} & \cdots & I_{2,M} \\ 
                   \vdots & \vdots &  & \vdots \\ 
                   I_{T,1} & I_{T,2} & \cdots & I_{T,M} \\ 
                 \end{array} \right).}
                 
  Indicators of record occurrence can be calculated for both upper and 
  lower records.
}
\examples{
X <- c(1, 5, 3, 6, 6, 9, 2, 11, 17, 8)
I.record(X)

I.record(ZaragozaSeries)
# record argument can be shortened
I.record(ZaragozaSeries, record = 'l')

}
\references{
Arnold BC, Balakrishnan N, Nagaraja HN (1998). 
\emph{Records}. New York: Wiley.
}
\seealso{
\code{\link{L.record}}, \code{\link{M.record}}, 
  \code{\link{N.record}}, \code{\link{Nmean.record}}, 
  \code{\link{P.record}}, \code{\link{records}}
}
\author{
Jorge Castillo-Mateo
}
