% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_MC.test.R
\name{L_MC.test}
\alias{L_MC.test}
\title{Monte Carlo likelihood ratio test on record times}
\usage{
L_MC.test(XM_T, record = "upper", samples = 1000)
}
\arguments{
\item{XM_T}{A matrix.}

\item{record}{A character string indicating the type of record to be calculated,  "upper" or "lower".}

\item{samples}{An integer specifying the number of replicates used in the Monte Carlo approach.}
}
\value{
A  \code{"htest"} object  with elements:
\item{statistic}{Value of the likelihood ratio statistic.}
\item{p.value}{P-value}
\item{method}{A character string indicating the type of test.}
\item{data.name}{A character string giving the name of the data.}
}
\description{
This function  performs a likelihood ratio test  based on the record times \eqn{L_i} to study the hypothesis of the classical record model using
a Monte Carlo approach.
}
\details{
The null  hypothesis  of this likelihood ratio test is that  in all the series, \eqn{m=1, ..., M}, the probability of record at time \eqn{t} is \eqn{1/t},
and the alternative that the probability at time \eqn{t} is any value, in any of the \eqn{M} series.  The alternative hypothesis
 is more general than the one  in \code{\link{L_lr.test}}.


   The statistic is the likelihood ratio statistic,  and the p-value
is obtained using a Monte Carlo approach.
}
\examples{
L_MC.test(ZaragozaSeries, samples = 200)
}
\seealso{
\code{\link{L.rec}}, \code{\link{L.plot}},  \code{\link{L_lr.test}}
}
